/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.entities.sorcery;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.sosly.arcaneadditions.effects.EffectRegistry;
import org.sosly.arcaneadditions.entities.EntityRegistry;

public class AstralProjectionEntity
extends Mob {
    private static final EntityDataAccessor<Optional<UUID>> RENDER_AS_UUID = SynchedEntityData.m_135353_(AstralProjectionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private Player cachedController;

    public AstralProjectionEntity(EntityType<? extends Mob> type, Level level) {
        super(type, level);
    }

    public AstralProjectionEntity(Player controller, Level level) {
        this((EntityType<? extends Mob>)((EntityType)EntityRegistry.ASTRAL_PROJECTION.get()), level);
        this.setPlayer(controller);
    }

    public Player getPlayer() {
        if (this.cachedController != null) {
            return this.cachedController;
        }
        Optional param = (Optional)this.f_19804_.m_135370_(RENDER_AS_UUID);
        if (!param.isPresent()) {
            return null;
        }
        UUID uuid = (UUID)param.get();
        this.cachedController = this.m_9236_().m_46003_(uuid);
        return this.cachedController;
    }

    public void setPlayer(Player controller) {
        this.f_19804_.m_135381_(RENDER_AS_UUID, Optional.of(controller.m_20148_()));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RENDER_AS_UUID, Optional.empty());
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        Player controller = this.getPlayer();
        if (controller == null) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (!controller.m_21023_((MobEffect)EffectRegistry.ASTRAL_PROJECTION.get()) || !this.m_21023_((MobEffect)EffectRegistry.ASTRAL_PROJECTION.get())) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (!controller.m_6084_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

