/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.entities.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.sosly.arcaneadditions.entities.ai.AbstractFamiliarGoal;

public class RandomWanderGoal
extends AbstractFamiliarGoal {
    private final double speed;
    private final int interval;
    private double wantedX;
    private double wantedY;
    private double wantedZ;

    public RandomWanderGoal(Mob familiar, double speed, int interval) {
        super(familiar);
        this.speed = speed;
        this.interval = interval;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.familiar.m_20160_()) {
            return false;
        }
        if (this.familiar.m_21216_() >= 100) {
            return false;
        }
        if (this.familiar.m_217043_().m_188503_(RandomWanderGoal.m_186073_((int)this.interval)) != 0) {
            return false;
        }
        Vec3 vec3 = this.getWanderVector(10, 7);
        if (vec3 == null) {
            return false;
        }
        this.wantedX = vec3.f_82479_;
        this.wantedY = vec3.f_82480_;
        this.wantedZ = vec3.f_82481_;
        return true;
    }

    public boolean m_8045_() {
        return !this.familiar.m_21573_().m_26571_() && !this.familiar.m_20160_();
    }

    @Override
    public void m_8056_() {
        this.familiar.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speed);
    }

    @Override
    public void m_8041_() {
        this.familiar.m_21573_().m_26573_();
        super.m_8041_();
    }

    @Nullable
    private Vec3 getWanderVector(int radius, int verticalDistance) {
        double d0 = Double.NEGATIVE_INFINITY;
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            BlockPos pos = this.getWanderTarget(radius, verticalDistance);
            if (pos == null) continue;
            double d1 = 0.0;
            Mob mob = this.familiar;
            if (mob instanceof PathfinderMob) {
                PathfinderMob pFamiliar = (PathfinderMob)mob;
                pFamiliar.m_21692_(pos);
            }
            if (!(d1 > d0)) continue;
            d0 = d1;
            blockpos = pos;
        }
        return blockpos != null ? Vec3.m_82539_(blockpos) : null;
    }

    @Nullable
    private BlockPos getWanderTarget(int radius, int verticalDistance) {
        BlockPos target;
        BlockPos goal = RandomPos.m_217851_((RandomSource)this.familiar.m_217043_(), (int)radius, (int)verticalDistance);
        Player caster = this.getCaster();
        BlockPos casterPos = caster != null ? caster.m_20183_() : null;
        int goalX = goal.m_123341_();
        int goalZ = goal.m_123343_();
        if (this.familiar.m_21536_() && radius > 1) {
            BlockPos blockpos = this.familiar.m_21534_();
            int distX = this.familiar.m_217043_().m_188503_(radius / 2);
            int distZ = this.familiar.m_217043_().m_188503_(radius / 2);
            goalX += this.familiar.m_20185_() > (double)blockpos.m_123341_() ? -distX : distX;
            goalZ += this.familiar.m_20189_() > (double)blockpos.m_123343_() ? -distZ : distZ;
        }
        if (this.isOutsideLimits(target = BlockPos.m_274561_((double)((double)goalX + this.familiar.m_20185_()), (double)((double)goal.m_123342_() + this.familiar.m_20186_()), (double)((double)goalZ + this.familiar.m_20189_())))) {
            return casterPos;
        }
        if (this.isRestricted(this.familiar.m_21536_(), target)) {
            return null;
        }
        if (this.needsStability() && !this.familiar.m_21573_().m_6342_(target)) {
            return casterPos;
        }
        if (this.familiar.m_21439_(WalkNodeEvaluator.m_77604_((BlockGetter)this.familiar.m_9236_(), (BlockPos.MutableBlockPos)target.m_122032_())) != 0.0f) {
            return casterPos;
        }
        return target;
    }

    private boolean needsStability() {
        return !(this.familiar.m_21566_() instanceof FlyingMoveControl);
    }

    private boolean isOutsideLimits(BlockPos pos) {
        return pos.m_123342_() < this.familiar.m_9236_().m_141937_() || pos.m_123342_() > this.familiar.m_9236_().m_151558_();
    }

    private boolean isRestricted(boolean shortCircuit, BlockPos pos) {
        return shortCircuit && this.familiar.m_21444_(pos);
    }
}

