/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.entities.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import org.sosly.arcaneadditions.config.ServerConfig;
import org.sosly.arcaneadditions.entities.ai.AbstractFamiliarGoal;

public class FollowCasterGoal
extends AbstractFamiliarGoal {
    private final LevelReader level;
    private final double followSpeed;
    private final PathNavigation navigator;
    private int timeToRecalcPath;
    private final float pathDist;
    private final float attackDist;
    private final float snapDist;
    private float oldWaterCost;
    private final boolean teleportToLeaves;

    public FollowCasterGoal(Mob familiar, double speed, float pathDist, float attackDist, float snapDist, boolean teleportToLeaves) {
        super(familiar);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(familiar.m_21573_() instanceof GroundPathNavigation || familiar.m_21573_() instanceof FlyingPathNavigation || familiar.m_21573_() instanceof WaterBoundPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
        this.level = familiar.m_9236_();
        this.followSpeed = speed;
        this.navigator = familiar.m_21573_();
        this.pathDist = pathDist;
        this.attackDist = attackDist;
        this.snapDist = snapDist;
        this.teleportToLeaves = teleportToLeaves;
    }

    public boolean m_8036_() {
        if (!this.hasValidCapability() || this.isOrderedToStay()) {
            return false;
        }
        Player caster = this.getCaster();
        if (caster == null) {
            return false;
        }
        if (this.familiar.m_20280_((Entity)caster) < (double)(this.snapDist * this.snapDist)) {
            return false;
        }
        if (this.familiar.m_5448_() != null && this.familiar.m_20280_((Entity)caster) < (double)(this.attackDist * this.attackDist)) {
            return false;
        }
        this.familiar.m_6710_(null);
        return true;
    }

    public boolean m_8045_() {
        return !this.navigator.m_26571_();
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.familiar.m_21439_(BlockPathTypes.WATER);
        this.familiar.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    @Override
    public void m_8041_() {
        this.navigator.m_26573_();
        this.familiar.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        super.m_8041_();
    }

    public void m_8037_() {
        if (!this.hasValidCapability()) {
            return;
        }
        Player caster = this.getCaster();
        if (caster == null) {
            return;
        }
        this.familiar.m_21563_().m_24960_((Entity)caster, (float)ServerConfig.familiarLookAtSpeed, (float)this.familiar.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = ServerConfig.familiarPathRecalcDelay;
            if (!this.familiar.m_21523_() && !this.familiar.m_20159_()) {
                if (this.familiar.m_20280_((Entity)caster) >= (double)(this.pathDist * this.pathDist)) {
                    this.tryToTeleportNearEntity();
                } else {
                    this.navigator.m_5624_((Entity)caster, this.followSpeed);
                }
            }
        }
    }

    private void tryToTeleportNearEntity() {
        if (!this.hasValidCapability()) {
            return;
        }
        Player caster = this.getCaster();
        if (caster == null) {
            return;
        }
        BlockPos blockpos = caster.m_20183_();
        for (int i = 0; i < ServerConfig.familiarTeleportAttempts; ++i) {
            int j = this.getRandomNumber(-ServerConfig.familiarTeleportDistance, ServerConfig.familiarTeleportDistance);
            int k = this.getRandomNumber(-1, 1);
            int l = this.getRandomNumber(-ServerConfig.familiarTeleportDistance, ServerConfig.familiarTeleportDistance);
            boolean flag = this.tryToTeleportToLocation(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean tryToTeleportToLocation(int x, int y, int z) {
        if (!this.hasValidCapability()) {
            return false;
        }
        Player caster = this.getCaster();
        if (caster == null) {
            return false;
        }
        if (Math.abs((double)x - caster.m_20185_()) < 2.0 && Math.abs((double)z - caster.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
            return false;
        }
        this.familiar.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, this.familiar.m_146908_(), this.familiar.m_146909_());
        this.navigator.m_26573_();
        return true;
    }

    private boolean isTeleportFriendlyBlock(BlockPos pos) {
        BlockPathTypes pathnodetype = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathnodetype != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.level.m_8055_(pos.m_7495_());
        if (!this.teleportToLeaves && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.m_121996_((Vec3i)this.familiar.m_20183_());
        return this.level.m_45756_((Entity)this.familiar, this.familiar.m_20191_().m_82338_(blockpos));
    }

    private int getRandomNumber(int min, int max) {
        return this.familiar.m_217043_().m_188503_(max - min + 1) + min;
    }
}

