/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.compats;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.minecraftforge.fml.ModList;
import org.sosly.arcaneadditions.ArcaneAdditions;
import org.sosly.arcaneadditions.api.spells.components.IPolymorphProvider;
import org.sosly.arcaneadditions.compats.Grass_Slabs.GrassSlabCompat;
import org.sosly.arcaneadditions.compats.ICompat;
import org.sosly.arcaneadditions.compats.Woodwalkers.WoodwalkersCompat;
import org.sosly.arcaneadditions.compats.magichem.MagiChemCompat;

public class CompatRegistry {
    private static final Map<String, Supplier<Callable<ICompat>>> compatFactories = new HashMap<String, Supplier<Callable<ICompat>>>();
    static IPolymorphProvider polymorphProvider;

    public static void registerCompats() {
        for (Map.Entry<String, Supplier<Callable<ICompat>>> entry : compatFactories.entrySet()) {
            if (!ModList.get().isLoaded(entry.getKey())) continue;
            try {
                entry.getValue().get().call().setup();
            }
            catch (Exception e) {
                ArcaneAdditions.LOGGER.error("Error instantiating compatibility ", (Throwable)e);
            }
        }
    }

    public static IPolymorphProvider getPolymorphCompat() {
        if (polymorphProvider != null) {
            return polymorphProvider;
        }
        if (ModList.get().isLoaded("walkers")) {
            polymorphProvider = new WoodwalkersCompat();
            return polymorphProvider;
        }
        return null;
    }

    static {
        compatFactories.put("walkers", () -> WoodwalkersCompat::new);
        compatFactories.put("grassslabs", () -> GrassSlabCompat::new);
        compatFactories.put("magichem", () -> MagiChemCompat::new);
    }
}

