/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.capabilities.treestride;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sosly.arcaneadditions.capabilities.treestride.ITreestrideCapability;
import org.sosly.arcaneadditions.capabilities.treestride.TreestrideCapability;

public class TreestrideProvider
implements ICapabilitySerializable<Tag> {
    public static final Capability<ITreestrideCapability> TREESTRIDE = CapabilityManager.get((CapabilityToken)new CapabilityToken<ITreestrideCapability>(){});
    private final LazyOptional<ITreestrideCapability> holder = LazyOptional.of(TreestrideCapability::new);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return TREESTRIDE.orEmpty(cap, this.holder);
    }

    public Tag serializeNBT() {
        ITreestrideCapability instance = (ITreestrideCapability)this.holder.orElse((Object)new TreestrideCapability());
        return TreestrideProvider.serializeNBT(instance);
    }

    public static Tag serializeNBT(ITreestrideCapability instance) {
        CompoundTag nbt = new CompoundTag();
        AtomicInteger playerCount = new AtomicInteger(0);
        instance.getAllDestinations().forEach((uuid, playerData) -> {
            CompoundTag playerNBT = new CompoundTag();
            playerNBT.m_128362_("uuid", uuid);
            AtomicInteger destinationCount = new AtomicInteger(0);
            playerData.forEach((pos, name) -> {
                CompoundTag destNBT = new CompoundTag();
                destNBT.m_128405_("x", pos.m_123341_());
                destNBT.m_128405_("y", pos.m_123342_());
                destNBT.m_128405_("z", pos.m_123343_());
                destNBT.m_128359_("name", name);
                int index = destinationCount.getAndIncrement();
                playerNBT.m_128365_(Integer.toString(index), (Tag)destNBT);
            });
            playerNBT.m_128405_("destinations", destinationCount.get());
            int index = playerCount.getAndIncrement();
            nbt.m_128365_(Integer.toString(index), (Tag)playerNBT);
        });
        nbt.m_128405_("players", playerCount.get());
        return nbt;
    }

    public void deserializeNBT(Tag nbt) {
        ITreestrideCapability instance = (ITreestrideCapability)this.holder.orElse((Object)new TreestrideCapability());
        if (nbt instanceof CompoundTag) {
            CompoundTag cnbt = (CompoundTag)nbt;
            int playerCount = cnbt.m_128451_("players");
            do {
                Tag tag;
                if (!((tag = cnbt.m_128423_(Integer.toString(playerCount))) instanceof CompoundTag)) continue;
                CompoundTag playerNBT = (CompoundTag)tag;
                UUID uuid = playerNBT.m_128342_("uuid");
                int destinationCount = playerNBT.m_128451_("destinations");
                do {
                    Tag tag2;
                    if (!((tag2 = playerNBT.m_128423_(Integer.toString(destinationCount))) instanceof CompoundTag)) continue;
                    CompoundTag destNBT = (CompoundTag)tag2;
                    BlockPos dest = new BlockPos(destNBT.m_128451_("x"), destNBT.m_128451_("y"), destNBT.m_128451_("z"));
                    String name = destNBT.m_128461_("name");
                    instance.addDestination(uuid, name, dest);
                } while (destinationCount-- > 0);
            } while (playerCount-- > 0);
        }
    }
}

