/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.capabilities.familiar;

import com.mna.spells.crafting.SpellRecipe;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sosly.arcaneadditions.capabilities.familiar.FamiliarCapability;
import org.sosly.arcaneadditions.capabilities.familiar.IFamiliarCapability;
import org.sosly.arcaneadditions.spells.FamiliarSpell;

public class FamiliarProvider
implements ICapabilitySerializable<Tag> {
    public static final Capability<IFamiliarCapability> FAMILIAR = CapabilityManager.get((CapabilityToken)new CapabilityToken<IFamiliarCapability>(){});
    private final LazyOptional<IFamiliarCapability> holder = LazyOptional.of(FamiliarCapability::new);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return FAMILIAR.orEmpty(cap, this.holder);
    }

    public Tag serializeNBT() {
        IFamiliarCapability instance = (IFamiliarCapability)this.holder.orElse((Object)new FamiliarCapability());
        CompoundTag nbt = new CompoundTag();
        if (instance.getCaster() != null) {
            nbt.m_128362_("caster", instance.getCaster().m_20148_());
        }
        if (instance.isBapped()) {
            nbt.m_128379_("bapped", instance.isBapped());
        }
        if (instance.getCastingResource() != null) {
            nbt.m_128359_("castingResourceId", instance.getCastingResource().getRegistryName().toString());
            instance.getCastingResource().writeNBT(nbt);
        }
        if (instance.getFamiliar() != null) {
            nbt.m_128362_("familiar", instance.getFamiliar().m_20148_());
        }
        if (instance.getLastInteract() > 0L) {
            nbt.m_128356_("lastInteract", instance.getLastInteract());
        }
        if (!instance.getName().isEmpty()) {
            nbt.m_128359_("name", instance.getName());
        }
        if (instance.getType() != null) {
            nbt.m_128359_("type", ((ResourceKey)ForgeRegistries.ENTITY_TYPES.getResourceKey(instance.getType()).get()).m_135782_().toString());
        }
        if (instance.isOrderedToStay()) {
            nbt.m_128379_("orderedToStay", instance.isOrderedToStay());
        }
        if (instance.getFamiliarNBT() != null) {
            nbt.m_128365_("familiarNBT", (Tag)instance.getFamiliarNBT());
        }
        if (!instance.getSpellsKnown().isEmpty()) {
            CompoundTag spells = new CompoundTag();
            int i = 0;
            for (FamiliarSpell spell : instance.getSpellsKnown()) {
                CompoundTag snbt = new CompoundTag();
                snbt.m_128379_("offensive", spell.isOffensive());
                snbt.m_128405_("frequency", spell.getFrequency().ordinal());
                snbt.m_128359_("name", spell.getName().getString());
                CompoundTag rnbt = new CompoundTag();
                spell.getRecipe().writeToNBT(rnbt);
                snbt.m_128365_("recipe", (Tag)rnbt);
                spells.m_128365_("spell_" + i++, (Tag)snbt);
            }
            nbt.m_128365_("spells", (Tag)spells);
        }
        return nbt;
    }

    public void deserializeNBT(Tag nbt) {
        IFamiliarCapability instance = (IFamiliarCapability)this.holder.orElse((Object)new FamiliarCapability());
        if (nbt instanceof CompoundTag) {
            CompoundTag cnbt = (CompoundTag)nbt;
            if (cnbt.m_128441_("bapped")) {
                instance.setBapped(cnbt.m_128471_("bapped"));
            }
            if (cnbt.m_128441_("castingResourceId")) {
                instance.setCastingResourceType(new ResourceLocation(cnbt.m_128461_("castingResourceId")));
            }
            instance.getCastingResource().readNBT(cnbt);
            instance.getCastingResource().setNeedsSync();
            if (instance.getFamiliar() != null) {
                instance.setFamiliarUUID(cnbt.m_128342_("familiar"));
            }
            if (cnbt.m_128441_("lastInteract")) {
                instance.setLastInteract(cnbt.m_128454_("lastInteract"));
            }
            if (cnbt.m_128441_("orderedToStay")) {
                instance.setOrderedToStay(cnbt.m_128471_("orderedToStay"));
            }
            if (cnbt.m_128441_("name")) {
                instance.setName(cnbt.m_128461_("name"));
            }
            if (cnbt.m_128441_("type")) {
                EntityType type = EntityType.m_20632_((String)cnbt.m_128461_("type")).orElse(null);
                if (type == null) {
                    throw new RuntimeException("Could not get type for Familiar.");
                }
                instance.setType((EntityType<? extends Mob>)type);
            }
            if (cnbt.m_128441_("familiarNBT")) {
                instance.setFamiliarNBT(cnbt.m_128469_("familiarNBT"));
            }
            if (cnbt.m_128441_("spells")) {
                CompoundTag spells = cnbt.m_128469_("spells");
                for (String key : spells.m_128431_()) {
                    CompoundTag snbt = spells.m_128469_(key);
                    SpellRecipe recipe = SpellRecipe.fromNBT((CompoundTag)snbt.m_128469_("recipe"));
                    if (recipe.getShape() == null) continue;
                    boolean offensive = snbt.m_128471_("offensive");
                    FamiliarSpell.Frequency frequency = FamiliarSpell.Frequency.values()[snbt.m_128451_("frequency")];
                    MutableComponent name = Component.m_237113_((String)snbt.m_128461_("name"));
                    FamiliarSpell spell = new FamiliarSpell((Component)name, recipe, frequency, offensive);
                    instance.addSpellKnown(spell, false);
                }
            }
        }
    }
}

