/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.blocks;

import com.mna.api.blocks.interfaces.ICutoutBlock;
import com.mna.api.blocks.interfaces.IOffsetPlace;
import com.mna.api.blocks.interfaces.ITranslucentBlock;
import com.mna.api.items.MACreativeTabs;
import com.mna.api.items.OffsetPlacerItem;
import com.mna.api.items.TieredBlockItem;
import java.util.Objects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.sosly.arcaneadditions.ArcaneAdditions;
import org.sosly.arcaneadditions.blocks.artifice.ScribesBenchBlock;
import org.sosly.arcaneadditions.models.ScribesBenchModel;

@Mod.EventBusSubscriber(modid="arcaneadditions", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"arcaneadditions");
    public static final RegistryObject<ScribesBenchBlock> SCRIBES_BENCH = BLOCKS.register("scribes_bench", ScribesBenchBlock::new);

    @SubscribeEvent
    public static void onRegisterItems(RegisterEvent event) {
        event.register(ForgeRegistries.ITEMS.getRegistryKey(), helper -> BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            Item.Properties properties = new Item.Properties();
            if (block instanceof IOffsetPlace) {
                IOffsetPlace adjuster = (IOffsetPlace)block;
                Objects.requireNonNull((IOffsetPlace)block);
                OffsetPlacerItem blockItem = new OffsetPlacerItem(block, properties, arg_0 -> ((IOffsetPlace)adjuster).adjustPlacement(arg_0));
                helper.register(ForgeRegistries.BLOCKS.getKey(block), (Object)blockItem);
            } else {
                TieredBlockItem blockItemx = new TieredBlockItem(block, properties);
                helper.register(ForgeRegistries.BLOCKS.getKey(block), (Object)blockItemx);
            }
        }));
    }

    @SubscribeEvent
    public static void fillCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == MACreativeTabs.GENERAL) {
            BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
                ItemStack stack = new ItemStack((ItemLike)block);
                if (!stack.m_41619_() && stack.m_41613_() == 1) {
                    event.m_246342_(stack);
                } else {
                    ArcaneAdditions.LOGGER.warn("unable to put {} in the creative tab", block);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onClientSetupEvent(FMLClientSetupEvent event) {
        BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            if (!(block instanceof ICutoutBlock) && !(block instanceof FlowerPotBlock)) {
                if (block instanceof ITranslucentBlock) {
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110466_());
                }
            } else {
                ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_());
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterSpecialModels(ModelEvent.RegisterAdditional event) {
        event.register(ScribesBenchModel.ink);
        event.register(ScribesBenchModel.lapis);
        event.register(ScribesBenchModel.source);
        event.register(ScribesBenchModel.target);
    }
}

