/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.StorageControllerBlock;
import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.ItemControllableDrawerTile;
import com.buuz135.functionalstorage.fluid.ControllerFluidHandler;
import com.buuz135.functionalstorage.inventory.ControllerInventoryHandler;
import com.buuz135.functionalstorage.inventory.ILockable;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.buuz135.functionalstorage.util.ConnectedDrawers;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class StorageControllerTile<T extends StorageControllerTile<T>>
extends ItemControllableDrawerTile<T> {
    protected static HashMap<UUID, Long> INTERACTION_LOGGER = new HashMap();
    @Save
    protected ConnectedDrawers connectedDrawers = new ConnectedDrawers(null, this);
    public ControllerInventoryHandler inventoryHandler = new ControllerInventoryHandler(){

        @Override
        public ConnectedDrawers getDrawers() {
            return StorageControllerTile.this.connectedDrawers;
        }
    };
    public ControllerFluidHandler fluidHandler;
    protected LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.inventoryHandler);
    protected LazyOptional<IFluidHandler> fluidHandlerLazyOptional;

    public StorageControllerTile(BasicTileBlock<T> base, BlockEntityType<T> entityType, BlockPos pos, BlockState state) {
        super(base, entityType, pos, state);
        this.fluidHandler = new ControllerFluidHandler(){

            @Override
            public ConnectedDrawers getDrawers() {
                return StorageControllerTile.this.connectedDrawers;
            }
        };
        this.fluidHandlerLazyOptional = LazyOptional.of(() -> this.fluidHandler);
    }

    @Override
    public int getStorageSlotAmount() {
        return 4;
    }

    @Override
    public double getStorageDiv() {
        return FunctionalStorageConfig.RANGE_DIVISOR;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        if (this.connectedDrawers.getConnectedDrawers().size() != this.connectedDrawers.getItemHandlers().size() + this.connectedDrawers.getFluidHandlers().size() + this.connectedDrawers.getExtensions()) {
            this.connectedDrawers.getConnectedDrawers().removeIf(aLong -> !(this.m_58904_().m_7702_(BlockPos.m_122022_((long)aLong)) instanceof ControllableDrawerTile));
            this.connectedDrawers.setLevel(this.m_58904_());
            this.connectedDrawers.rebuild();
            this.markForUpdate();
            this.updateNeigh();
        }
    }

    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (stack.m_41720_().equals(FunctionalStorage.CONFIGURATION_TOOL.get()) || stack.m_41720_().equals(FunctionalStorage.LINKING_TOOL.get())) {
            return InteractionResult.PASS;
        }
        if (this.isServer()) {
            int slot;
            if (playerIn.m_6047_()) {
                this.openGui(playerIn);
            } else {
                playerIn.m_5661_((Component)Component.m_237115_((String)"gui.functionalstorage.open_gui").m_130940_(ChatFormatting.GRAY), true);
            }
            for (IItemHandler iItemHandler : this.connectedDrawers.getItemHandlers()) {
                if (!(iItemHandler instanceof ILockable) || !((ILockable)iItemHandler).isLocked()) continue;
                for (slot = 0; slot < iItemHandler.getSlots(); ++slot) {
                    if (!stack.m_41619_() && iItemHandler.insertItem(slot, stack, true).m_41613_() != stack.m_41613_()) {
                        playerIn.m_21008_(hand, iItemHandler.insertItem(slot, stack, false));
                        return InteractionResult.SUCCESS;
                    }
                    if (System.currentTimeMillis() - INTERACTION_LOGGER.getOrDefault(playerIn.m_20148_(), System.currentTimeMillis()) >= 300L) continue;
                    for (ItemStack itemStack : playerIn.m_150109_().f_35974_) {
                        if (itemStack.m_41619_() || iItemHandler.insertItem(slot, itemStack, true).m_41613_() == itemStack.m_41613_()) continue;
                        itemStack.m_41764_(iItemHandler.insertItem(slot, itemStack.m_41777_(), false).m_41613_());
                    }
                }
            }
            for (IItemHandler iItemHandler : this.connectedDrawers.getItemHandlers()) {
                if (!(iItemHandler instanceof ILockable) || ((ILockable)iItemHandler).isLocked()) continue;
                for (slot = 0; slot < iItemHandler.getSlots(); ++slot) {
                    if (!stack.m_41619_() && !iItemHandler.getStackInSlot(slot).m_41619_() && iItemHandler.insertItem(slot, stack, true).m_41613_() != stack.m_41613_()) {
                        playerIn.m_21008_(hand, iItemHandler.insertItem(slot, stack, false));
                        return InteractionResult.SUCCESS;
                    }
                    if (System.currentTimeMillis() - INTERACTION_LOGGER.getOrDefault(playerIn.m_20148_(), System.currentTimeMillis()) >= 300L) continue;
                    for (ItemStack itemStack : playerIn.m_150109_().f_35974_) {
                        if (itemStack.m_41619_() || iItemHandler.getStackInSlot(slot).m_41619_() || iItemHandler.insertItem(slot, itemStack, true).m_41613_() == itemStack.m_41613_()) continue;
                        itemStack.m_41764_(iItemHandler.insertItem(slot, itemStack.m_41777_(), false).m_41613_());
                    }
                }
            }
            INTERACTION_LOGGER.put(playerIn.m_20148_(), System.currentTimeMillis());
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        if (this.getStorageSlotAmount() > 0) {
            this.addGuiAddonFactory(() -> new TextScreenAddon("gui.functionalstorage.storage_range", 10, 59, false, ChatFormatting.DARK_GRAY.m_126665_()){

                public String getText() {
                    return Component.m_237115_((String)"gui.functionalstorage.storage_range").getString();
                }
            });
        }
        this.addGuiAddonFactory(() -> new TextScreenAddon("key.categories.inventory", 8, 92, false, ChatFormatting.DARK_GRAY.m_126665_()){

            public String getText() {
                return Component.m_237115_((String)"key.categories.inventory").getString();
            }
        });
    }

    @Override
    public IItemHandler getStorage() {
        return this.inventoryHandler;
    }

    @Override
    public LazyOptional<IItemHandler> getOptional() {
        return this.itemHandlerLazyOptional;
    }

    @Override
    public int getBaseSize(int lost) {
        return 1;
    }

    @Override
    public void toggleLocking() {
        super.toggleLocking();
        if (this.isServer()) {
            for (Long connectedDrawer : new ArrayList<Long>(this.connectedDrawers.getConnectedDrawers())) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(BlockPos.m_122022_((long)connectedDrawer));
                if (blockEntity instanceof StorageControllerTile || !(blockEntity instanceof ControllableDrawerTile)) continue;
                ((ControllableDrawerTile)blockEntity).setLocked(this.isLocked());
            }
        }
    }

    @Override
    public void toggleOption(ConfigurationToolItem.ConfigurationAction action) {
        super.toggleOption(action);
        if (this.isServer()) {
            for (Long connectedDrawer : new ArrayList<Long>(this.connectedDrawers.getConnectedDrawers())) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(BlockPos.m_122022_((long)connectedDrawer));
                if (blockEntity instanceof StorageControllerTile || !(blockEntity instanceof ControllableDrawerTile)) continue;
                if (action.getMax() == 1) {
                    ((ControllableDrawerTile)blockEntity).getDrawerOptions().setActive(action, this.getDrawerOptions().isActive(action));
                } else {
                    ((ControllableDrawerTile)blockEntity).getDrawerOptions().setAdvancedValue(action, this.getDrawerOptions().getAdvancedValue(action));
                }
                ((ControllableDrawerTile)blockEntity).markForUpdate();
            }
        }
    }

    public ConnectedDrawers getConnectedDrawers() {
        return this.connectedDrawers;
    }

    @Override
    public int getUtilitySlotAmount() {
        return 0;
    }

    public boolean addConnectedDrawers(LinkingToolItem.ActionMode action, BlockPos ... positions) {
        int extraRange = this.getStorageMultiplier();
        if (extraRange == 1) {
            extraRange = 0;
        }
        boolean didWork = false;
        AABB area = new AABB(this.m_58899_()).m_82400_((double)(FunctionalStorageConfig.DRAWER_CONTROLLER_LINKING_RANGE + extraRange));
        for (BlockPos position : positions) {
            BlockEntity blockEntity;
            if (this.f_58857_.m_8055_(position).m_60734_() instanceof StorageControllerBlock) continue;
            if (area.m_82390_(Vec3.m_82512_((Vec3i)position)) && (blockEntity = this.m_58904_().m_7702_(position)) instanceof ControllableDrawerTile) {
                ControllableDrawerTile controllableDrawerTile2 = (ControllableDrawerTile)blockEntity;
                if (action == LinkingToolItem.ActionMode.ADD) {
                    controllableDrawerTile2.setControllerPos(this.m_58899_());
                    if (!this.connectedDrawers.getConnectedDrawers().contains(position.m_121878_())) {
                        this.connectedDrawers.getConnectedDrawers().add(position.m_121878_());
                        didWork = true;
                    }
                }
            }
            if (action != LinkingToolItem.ActionMode.REMOVE) continue;
            this.connectedDrawers.getConnectedDrawers().removeIf(aLong -> aLong.longValue() == position.m_121878_());
            TileUtil.getTileEntity((BlockGetter)this.f_58857_, (BlockPos)position, ControllableDrawerTile.class).ifPresent(controllableDrawerTile -> controllableDrawerTile.clearControllerPos());
            didWork = true;
        }
        this.connectedDrawers.rebuild();
        this.markForUpdate();
        return didWork;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHandlerLazyOptional.invalidate();
        this.itemHandlerLazyOptional.invalidate();
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_(1200.0);
    }

    @Override
    public InventoryComponent<ControllableDrawerTile<T>> getStorageUpgradesConstructor() {
        return new InventoryComponent("storage_upgrades", 10, 70, this.getStorageSlotAmount()).setInputFilter((stack, integer) -> {
            if (stack.m_41720_().equals(FunctionalStorage.STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.IRON).get())) {
                for (int i = 0; i < this.getStorage().getSlots(); ++i) {
                    if (this.getStorage().getStackInSlot(i).m_41613_() <= 64) continue;
                    return false;
                }
            }
            return stack.m_41720_() instanceof UpgradeItem && ((UpgradeItem)stack.m_41720_()).getType() == UpgradeItem.Type.STORAGE;
        }).setOnSlotChanged((stack, integer) -> {
            this.setNeedsUpgradeCache(true);
            this.connectedDrawers.rebuild();
            this.connectedDrawers.rebuildShapes();
            this.markForUpdate();
        }).setSlotLimit(1);
    }
}

