/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ItemControllableDrawerTile;
import com.buuz135.functionalstorage.client.gui.DrawerInfoGuiAddon;
import com.buuz135.functionalstorage.inventory.BigInventoryHandler;
import com.buuz135.functionalstorage.util.IWoodType;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class DrawerTile
extends ItemControllableDrawerTile<DrawerTile> {
    @Save
    public BigInventoryHandler handler;
    private final LazyOptional<IItemHandler> lazyStorage;
    private FunctionalStorage.DrawerType type;
    private IWoodType woodType;

    public DrawerTile(BasicTileBlock<DrawerTile> base, BlockEntityType<DrawerTile> blockEntityType, BlockPos pos, BlockState state, FunctionalStorage.DrawerType type, IWoodType woodType) {
        super(base, blockEntityType, pos, state);
        this.type = type;
        this.woodType = woodType;
        this.handler = new BigInventoryHandler(type){

            @Override
            public void onChange() {
                DrawerTile.this.markForUpdate();
            }

            @Override
            public int getMultiplier() {
                return DrawerTile.this.getStorageMultiplier();
            }

            @Override
            public boolean isVoid() {
                return DrawerTile.this.isVoid();
            }

            @Override
            public boolean hasDowngrade() {
                return DrawerTile.this.hasDowngrade();
            }

            @Override
            public boolean isLocked() {
                return DrawerTile.this.isLocked();
            }

            @Override
            public boolean isCreative() {
                return DrawerTile.this.isCreative();
            }
        };
        this.lazyStorage = LazyOptional.of(() -> this.handler);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new DrawerInfoGuiAddon(64, 16, new ResourceLocation("functionalstorage", "textures/block/" + this.woodType.getName() + "_front_" + this.type.getSlots() + ".png"), this.type.getSlots(), this.type.getSlotPosition(), integer -> this.getHandler().getStackInSlot((int)integer), integer -> this.getHandler().getSlotLimit((int)integer)));
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ, int slot) {
        BigInventoryHandler.BigStack bigStack;
        ItemStack stack = playerIn.m_21120_(hand);
        if (stack.m_41720_().equals(FunctionalStorage.CONFIGURATION_TOOL.get()) || stack.m_41720_().equals(FunctionalStorage.LINKING_TOOL.get())) {
            return InteractionResult.PASS;
        }
        if (slot != -1 && !playerIn.m_21120_(hand).m_41619_() && (bigStack = this.getHandler().getStoredStacks().get(slot)).getStack().m_41619_()) {
            bigStack.setStack(playerIn.m_21120_(hand));
        }
        return super.onSlotActivated(playerIn, hand, facing, hitX, hitY, hitZ, slot);
    }

    @NotNull
    public DrawerTile getSelf() {
        return this;
    }

    public FunctionalStorage.DrawerType getDrawerType() {
        return this.type;
    }

    @Override
    public int getStorageSlotAmount() {
        return 4;
    }

    @Override
    public IItemHandler getStorage() {
        return this.handler;
    }

    @Override
    public LazyOptional<IItemHandler> getOptional() {
        return this.lazyStorage;
    }

    @Override
    public int getBaseSize(int lost) {
        return this.type.getSlotAmount();
    }

    public BigInventoryHandler getHandler() {
        return this.handler;
    }
}

