/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.project;

import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.project.IProject;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.project.ProjectFile;
import com.tom.cpm.shared.editor.project.ProjectPartLoader;
import com.tom.cpm.shared.editor.project.ProjectWriter;
import com.tom.cpm.shared.editor.project.loaders.AnimationsLoaderV1;
import com.tom.cpm.shared.editor.project.loaders.DescriptionLoaderV1;
import com.tom.cpm.shared.editor.project.loaders.ElementsLoaderV1;
import com.tom.cpm.shared.editor.project.loaders.PropertiesLoaderV1;
import com.tom.cpm.shared.editor.project.loaders.TagsLoaderV1;
import com.tom.cpm.shared.editor.project.loaders.TemplateLoaderV1;
import com.tom.cpm.shared.editor.project.loaders.TexturesLoaderV1;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class ProjectIO {
    public static final int projectFileVersion = 1;
    public static Map<Integer, ProjectIO> loaders = new HashMap<Integer, ProjectIO>();
    public Map<String, ProjectPartLoader> partLoaders;

    public ProjectIO() {
        this.partLoaders = new HashMap<String, ProjectPartLoader>();
    }

    private static void load(Set<ProjectPartLoader> l) {
        l.add(new AnimationsLoaderV1());
        l.add(new DescriptionLoaderV1());
        l.add(new ElementsLoaderV1());
        l.add(new PropertiesLoaderV1());
        l.add(new TemplateLoaderV1());
        l.add(new TexturesLoaderV1());
        l.add(new TagsLoaderV1());
    }

    public ProjectIO(ProjectIO pl) {
        this.partLoaders = new HashMap<String, ProjectPartLoader>(pl.partLoaders);
    }

    public static void loadProject(Editor editor, IProject project) throws IOException {
        JsonMap data = project.getJson("config.json");
        int version = data.getInt("version");
        ProjectIO loader = loaders.get(version);
        Iterator itr = loader.partLoaders.values().stream().sorted(Comparator.comparing(ProjectPartLoader::getLoadOrder)).iterator();
        while (itr.hasNext()) {
            ProjectPartLoader p = (ProjectPartLoader)itr.next();
            p.load(editor, project);
        }
    }

    public static void saveProject(Editor editor, ProjectFile project) throws IOException {
        ProjectWriter.Impl writer = new ProjectWriter.Impl(project);
        ProjectIO loader = loaders.get(1);
        JsonMap data = writer.getJson("config.json");
        data.put("version", 1);
        for (ProjectPartLoader p : loader.partLoaders.values()) {
            p.save(editor, writer);
        }
        writer.flush();
    }

    static {
        HashSet<ProjectPartLoader> l = new HashSet<ProjectPartLoader>();
        ProjectIO.load(l);
        TreeMap ls = l.stream().collect(Collectors.toMap(ProjectPartLoader::getVersion, v -> {
            HashSet<ProjectPartLoader> s = new HashSet<ProjectPartLoader>();
            s.add((ProjectPartLoader)v);
            return s;
        }, (a, b) -> {
            a.addAll(b);
            return a;
        }, TreeMap::new));
        ProjectIO loader = new ProjectIO();
        for (Map.Entry e : ls.entrySet()) {
            loaders.put((Integer)e.getKey(), loader);
            ProjectIO fpl = loader;
            ((Set)e.getValue()).forEach(p -> fpl.partLoaders.put(p.getId(), (ProjectPartLoader)p));
            loader = new ProjectIO(loader);
        }
    }
}

