/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ButtonIcon;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.DropDownBox;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.TabFocusHandler;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.util.Direction;
import com.tom.cpl.util.NamedElement;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.model.render.PerFaceUV;
import java.util.ArrayList;
import java.util.Locale;

public class PerfaceUVPanel
extends Panel {
    private Spinner spinnerSU;
    private Spinner spinnerSV;
    private Spinner spinnerEU;
    private Spinner spinnerEV;

    public PerfaceUVPanel(Frame frm, Editor editor, TabFocusHandler tabHandler) {
        super(frm.getGui());
        this.setBounds(new Box(0, 0, 170, 100));
        NamedElement.NameMapper<Direction> dirMap = new NamedElement.NameMapper<Direction>(Direction.VALUES, dir -> this.gui.i18nFormat("label.cpm.dir." + dir.name().toLowerCase(Locale.ROOT), new Object[0]));
        DropDownBox<NamedElement<Direction>> faces = new DropDownBox<NamedElement<Direction>>(frm, dirMap.asList());
        faces.setBounds(new Box(5, 0, 160, 20));
        dirMap.setSetter(faces::setSelected);
        faces.setAction(() -> {
            editor.perfaceFaceDir.accept((Direction)((Object)((Object)((NamedElement)faces.getSelected()).getElem())));
            editor.updateGui();
        });
        editor.perfaceFaceDir.add(dirMap::setValue);
        this.addElement(faces);
        this.spinnerSU = new Spinner(this.gui);
        this.spinnerSV = new Spinner(this.gui);
        this.spinnerEU = new Spinner(this.gui);
        this.spinnerEV = new Spinner(this.gui);
        this.spinnerSU.setBounds(new Box(5, 25, 35, 20));
        this.spinnerSV.setBounds(new Box(45, 25, 35, 20));
        this.spinnerEU.setBounds(new Box(90, 25, 35, 20));
        this.spinnerEV.setBounds(new Box(130, 25, 35, 20));
        this.spinnerSU.setDp(0);
        this.spinnerSV.setDp(0);
        this.spinnerEU.setDp(0);
        this.spinnerEV.setDp(0);
        Runnable r = () -> {
            ModelElement el = editor.getSelectedElement();
            if (el != null && el.faceUV != null) {
                ActionBuilder ab = editor.action("set", "action.cpm.texUV");
                PerFaceUV.Face f = PerfaceUVPanel.getFace(editor, ab);
                Vec4f v = new Vec4f(this.spinnerSU.getValue(), this.spinnerSV.getValue(), this.spinnerEU.getValue(), this.spinnerEV.getValue());
                if (f.autoUV) {
                    PerfaceUVPanel.autoUV(v, editor.perfaceFaceDir.get(), el.size);
                    editor.setFaceUVs.accept(v);
                }
                ab.updateValueOp(f, f.getVec(), v, PerFaceUV.Face::set);
                ab.onAction(el::markDirty);
                ab.execute();
            }
        };
        Runnable r2 = () -> {
            ModelElement el = editor.getSelectedElement();
            if (el != null && el.faceUV != null) {
                ActionBuilder ab = editor.action("set", "action.cpm.texUV");
                PerFaceUV.Face f = PerfaceUVPanel.getFace(editor, ab);
                Vec4f v = new Vec4f(this.spinnerSU.getValue(), this.spinnerSV.getValue(), this.spinnerEU.getValue(), this.spinnerEV.getValue());
                ab.updateValueOp(f, f.getVec(), v, PerFaceUV.Face::set);
                ab.updateValueOp(f, f.autoUV, false, (a, b) -> {
                    a.autoUV = b;
                });
                ab.onAction(el::markDirty);
                ab.execute();
            }
        };
        this.spinnerSU.addChangeListener(r);
        this.spinnerSV.addChangeListener(r);
        this.spinnerEU.addChangeListener(r2);
        this.spinnerEV.addChangeListener(r2);
        tabHandler.add(this.spinnerSU);
        tabHandler.add(this.spinnerSV);
        tabHandler.add(this.spinnerEU);
        tabHandler.add(this.spinnerEV);
        this.addElement(this.spinnerSU);
        this.addElement(this.spinnerSV);
        this.addElement(this.spinnerEU);
        this.addElement(this.spinnerEV);
        editor.setFaceUVs.add(v -> {
            this.spinnerSU.setValue(v.x);
            this.spinnerSV.setValue(v.y);
            this.spinnerEU.setValue(v.z);
            this.spinnerEV.setValue(v.w);
        });
        NamedElement.NameMapper<PerFaceUV.Rot> rotMap = new NamedElement.NameMapper<PerFaceUV.Rot>(PerFaceUV.Rot.VALUES, rot -> this.gui.i18nFormat("label.cpm.rot." + rot.name().toLowerCase(Locale.ROOT), new Object[0]));
        DropDownBox<NamedElement<PerFaceUV.Rot>> rots = new DropDownBox<NamedElement<PerFaceUV.Rot>>(frm, new ArrayList<NamedElement<PerFaceUV.Rot>>(rotMap.asList()));
        rotMap.setSetter(rots::setSelected);
        rots.setBounds(new Box(5, 50, 80, 20));
        rots.setAction(() -> {
            ModelElement el = editor.getSelectedElement();
            if (el != null && el.faceUV != null) {
                ActionBuilder ab = editor.action("rotateUV");
                PerFaceUV.Face f = PerfaceUVPanel.getFace(editor, ab);
                ab.updateValueOp(f, f.rotation, (PerFaceUV.Rot)((Object)((Object)((NamedElement)rots.getSelected()).getElem())), (a, b) -> {
                    a.rotation = b;
                });
                ab.onAction(el::markDirty);
                ab.execute();
            }
        });
        editor.setFaceRot.add(rotMap::setValue);
        this.addElement(rots);
        Checkbox autoUV = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.auto_uv", new Object[0]));
        autoUV.setAction(() -> {
            autoUV.setSelected(!autoUV.isSelected());
            ModelElement el = editor.getSelectedElement();
            if (el != null && el.faceUV != null) {
                ActionBuilder ab = editor.action("autoUV");
                PerFaceUV.Face f = PerfaceUVPanel.getFace(editor, ab);
                ab.updateValueOp(f, f.autoUV, autoUV.isSelected(), (a, b) -> {
                    a.autoUV = b;
                });
                if (!f.autoUV) {
                    Vec4f v = f.getVec();
                    PerfaceUVPanel.autoUV(v, editor.perfaceFaceDir.get(), el.size);
                    ab.updateValueOp(f, f.getVec(), v, PerFaceUV.Face::set);
                    editor.setFaceUVs.accept(v);
                }
                ab.onAction(el::markDirty);
                ab.execute();
            }
        });
        autoUV.setBounds(new Box(5, 75, 60, 20));
        editor.setAutoUV.add(autoUV::updateState);
        this.addElement(autoUV);
        ButtonIcon delBtn = new ButtonIcon(this.gui, "editor", 16, 16, () -> {
            PerFaceUV.Face f;
            ModelElement el = editor.getSelectedElement();
            if (el != null && el.faceUV != null && (f = el.faceUV.faces.get((Object)editor.perfaceFaceDir.get())) != null) {
                editor.action("deleteFace").removeFromMap(el.faceUV.faces, editor.perfaceFaceDir.get(), f).onAction(el::markDirty).execute();
                editor.updateGui();
            }
        });
        delBtn.setBounds(new Box(70, 75, 20, 20));
        delBtn.setTooltip(new Tooltip(frm, this.gui.i18nFormat("tooltip.cpm.deleteFace", new Object[0])));
        this.addElement(delBtn);
        Button toAllUVs = new Button(this.gui, this.gui.i18nFormat("button.cpm.toAllFaces", new Object[0]), () -> {
            PerFaceUV.Face f;
            ModelElement el = editor.getSelectedElement();
            if (el != null && el.faceUV != null && (f = el.faceUV.faces.get((Object)editor.perfaceFaceDir.get())) != null) {
                ActionBuilder ab = editor.action("toAllFaces");
                for (Direction d : Direction.VALUES) {
                    if (d == editor.perfaceFaceDir.get()) continue;
                    ab.addToMap(el.faceUV.faces, d, new PerFaceUV.Face(f));
                }
                ab.onAction(el::markDirty);
                ab.execute();
                editor.updateGui();
            }
        });
        toAllUVs.setBounds(new Box(95, 75, 70, 20));
        toAllUVs.setTooltip(new Tooltip(frm, this.gui.i18nFormat("tooltip.cpm.toAllFaces", new Object[0])));
        this.addElement(toAllUVs);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.spinnerSU.setVisible(visible);
        this.spinnerSV.setVisible(visible);
        this.spinnerEU.setVisible(visible);
        this.spinnerEV.setVisible(visible);
    }

    private static PerFaceUV.Face getFace(Editor editor, ActionBuilder ab) {
        ModelElement el = editor.getSelectedElement();
        PerFaceUV.Face f = el.faceUV.faces.get((Object)editor.perfaceFaceDir.get());
        if (f == null) {
            f = new PerFaceUV.Face();
            ab.addToMap(el.faceUV.faces, editor.perfaceFaceDir.get(), f);
        }
        return f;
    }

    private static void autoUV(Vec4f v, Direction dir, Vec3f size) {
        int dx = MathHelper.ceil(size.x);
        int dy = MathHelper.ceil(size.y);
        int dz = MathHelper.ceil(size.z);
        int tx = (int)v.x;
        int ty = (int)v.y;
        switch (dir) {
            case NORTH: 
            case SOUTH: {
                tx += dx;
                ty += dy;
                break;
            }
            case UP: 
            case DOWN: {
                tx += dx;
                ty += dz;
                break;
            }
            case EAST: 
            case WEST: {
                tx += dz;
                ty += dy;
                break;
            }
        }
        v.z = tx;
        v.w = ty;
    }
}

