/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor;

import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.Pair;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.InterpolatorChannel;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ExportException;
import com.tom.cpm.shared.editor.anim.AnimFrame;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.anim.IElem;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.parts.anim.AnimLoaderState;
import com.tom.cpm.shared.parts.anim.AnimatorChannel;
import com.tom.cpm.shared.parts.anim.ConstantTimeBool;
import com.tom.cpm.shared.parts.anim.ConstantTimeFloat;
import com.tom.cpm.shared.parts.anim.ParameterDetails;
import com.tom.cpm.shared.parts.anim.SerializedAnimation;
import com.tom.cpm.shared.parts.anim.SerializedTrigger;
import com.tom.cpm.shared.parts.anim.StageType;
import com.tom.cpm.shared.parts.anim.menu.AbstractGestureButtonData;
import com.tom.cpm.shared.parts.anim.menu.BoolParameterToggleButtonData;
import com.tom.cpm.shared.parts.anim.menu.CustomPoseGestureButtonData;
import com.tom.cpm.shared.parts.anim.menu.DropdownButtonData;
import com.tom.cpm.shared.parts.anim.menu.ValueParameterButtonData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AnimationExporter {
    public final Editor editor;
    public final AnimLoaderState an;
    public ParameterDetails.ParameterAllocator paramAlloc = new ParameterDetails.ParameterAllocator();
    public List<Pair<Integer, AbstractGestureButtonData>> buttons = new ArrayList<Pair<Integer, AbstractGestureButtonData>>();
    public Map<String, ParameterInfo> allButtons = new HashMap<String, ParameterInfo>();
    public Set<ModelElement> allElems = new HashSet<ModelElement>();
    public Map<SerializedTrigger, Integer> triggers = new HashMap<SerializedTrigger, Integer>();
    public Map<EditorAnim, Integer> animTriggers = new HashMap<EditorAnim, Integer>();
    public Map<EditorAnim, SerializedAnimation> anims = new HashMap<EditorAnim, SerializedAnimation>();
    public Map<EditorAnim, Staging> stagingAnimMap = new HashMap<EditorAnim, Staging>();
    public List<Staging> stagingAnimList = new ArrayList<Staging>();
    public Map<String, Integer> dropdownParams = new HashMap<String, Integer>();
    public Map<EditorAnim, Integer> dropdownAnims = new HashMap<EditorAnim, Integer>();

    public AnimationExporter(Editor editor, AnimLoaderState an) {
        this.editor = editor;
        this.an = an;
    }

    public void processElements() {
        Editor.walkElements(this.editor.elements, this.allElems::add);
    }

    public void processAnimation(EditorAnim a) {
        SerializedTrigger tr = new SerializedTrigger();
        if (a.pose instanceof VanillaPose) {
            tr.pose = (VanillaPose)a.pose;
            tr.mustFinish = a.mustFinish;
        } else if (a.type == AnimationType.CUSTOM_POSE || a.type == AnimationType.GESTURE || a.type.isLayer()) {
            boolean bl = tr.looping = a.type == AnimationType.GESTURE ? a.loop : true;
            if (!this.allButtons.containsKey(a.getId())) {
                int len;
                ParameterInfo info = this.makeButtonInfo(a);
                if (!a.type.isLayer()) {
                    info.button.layerCtrl = a.layerControlled;
                }
                info.button.command = a.command;
                info.button.isProperty = a.isProperty;
                info.apply(tr);
                if (a.type == AnimationType.GESTURE && !a.loop && (len = this.editor.animations.stream().mapToInt(ax -> ax.duration).max().orElse(-1)) > 0) {
                    ((CustomPoseGestureButtonData)info.button).gestureTimeout = (int)Math.ceil((float)len / 50.0f) + 5;
                }
            } else {
                this.allButtons.get(a.getId()).apply(tr);
            }
            tr.anim = a.type;
            tr.mustFinish = a.mustFinish;
        } else if (a.type.isStaged()) {
            List<EditorAnim> l = a.findLinkedAnims().collect(Collectors.toList());
            Staging st = l.stream().map(this.stagingAnimMap::get).filter(e -> e != null).findFirst().orElseGet(() -> {
                Staging s = new Staging();
                s.id = this.stagingAnimList.size();
                this.stagingAnimList.add(s);
                this.stagingAnimMap.put(a, s);
                return s;
            });
            l.forEach(ea -> this.stagingAnimMap.put((EditorAnim)ea, st));
            this.stagingAnimMap.put(a, st);
            st.play.addAll(l);
            if (a.type == AnimationType.SETUP) {
                st.setup.add(a);
            } else {
                st.finish.add(a);
            }
            tr.stage = a.type == AnimationType.SETUP ? StageType.SETUP : StageType.FINISH;
            tr.stagingID = st.id;
        }
        int id = this.triggers.computeIfAbsent(tr, this.an::newTrigger);
        this.animTriggers.put(a, id);
        SerializedAnimation anim = new SerializedAnimation();
        this.anims.put(a, anim);
        anim.triggerID = id;
        anim.priority = a.priority;
        anim.duration = a.pose instanceof VanillaPose && ((VanillaPose)a.pose).hasStateGetter() || a.type == AnimationType.VALUE_LAYER ? 1001 : a.duration;
        this.an.newAnimation(anim);
        List<ModelElement> elems = a.getComponentsFiltered();
        List<AnimFrame> frames = a.getFrames();
        elems.forEach(me -> {
            if (!this.allElems.contains(me)) {
                return;
            }
            Map<InterpolatorChannel, Integer> c = AnimatorChannel.addCubeToChannels(anim, me.id, a.add);
            if (frames.stream().anyMatch(f -> f.hasPosChanges((ModelElement)me))) {
                AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.POS_X, a, 0.0f);
                AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.POS_Y, a, 0.0f);
                AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.POS_Z, a, 0.0f);
            }
            if (frames.stream().anyMatch(f -> f.hasRotChanges((ModelElement)me))) {
                AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.ROT_X, a, 0.0f);
                AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.ROT_Y, a, 0.0f);
                AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.ROT_Z, a, 0.0f);
            }
            if (frames.stream().anyMatch(f -> f.hasColorChanges((ModelElement)me))) {
                AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.COLOR_R, a, 0.0f);
                AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.COLOR_G, a, 0.0f);
                AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.COLOR_B, a, 0.0f);
            }
            if (frames.stream().anyMatch(f -> f.hasVisChanges((ModelElement)me))) {
                boolean[] array = new boolean[frames.size()];
                for (int i = 0; i < frames.size(); ++i) {
                    AnimFrame frm = (AnimFrame)frames.get(i);
                    IElem dt = frm.getData((ModelElement)me);
                    array[i] = dt == null ? me.isVisible() : dt.isVisible();
                }
                anim.animatorChannels.get((Object)c.get(null)).frameData = new ConstantTimeBool(array);
            }
            if (frames.stream().anyMatch(f -> f.hasScaleChanges((ModelElement)me))) {
                AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.SCALE_X, a, 1.0f);
                AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.SCALE_Y, a, 1.0f);
                AnimationExporter.addChannel(anim, c, me, InterpolatorChannel.SCALE_Z, a, 1.0f);
            }
        });
    }

    private static void addChannel(SerializedAnimation anim, Map<InterpolatorChannel, Integer> c, ModelElement elem, InterpolatorChannel chn, EditorAnim ea, float empty) {
        List<AnimFrame> frames = ea.getFrames();
        float[] array = new float[frames.size()];
        for (int i = 0; i < frames.size(); ++i) {
            AnimFrame frm = frames.get(i);
            IElem dt = frm.getData(elem);
            if (dt == null) {
                if (ea.add) {
                    array[i] = empty;
                    continue;
                }
                array[i] = elem.part(chn);
                continue;
            }
            array[i] = dt.part(chn);
        }
        anim.animatorChannels.get((Object)c.get((Object)chn)).frameData = new ConstantTimeFloat(ea.intType, array);
    }

    public List<AbstractGestureButtonData> sortButtons() {
        return this.buttons.stream().sorted(Comparator.comparingInt(Pair::getKey)).map(Pair::getValue).collect(Collectors.toList());
    }

    public void linkStagingAnims() {
        this.stagingAnimList.forEach(s -> {
            SerializedTrigger tr = new SerializedTrigger();
            tr.stagingID = s.id;
            tr.stage = StageType.PLAY;
            tr.mustFinish = s.play.stream().anyMatch(e -> e.mustFinish);
            int id = this.triggers.computeIfAbsent(tr, this.an::newTrigger);
            List trigs = s.play.stream().map(this.animTriggers::get).map(this.an.getTriggers()::get).filter(e -> e != null).distinct().collect(Collectors.toList());
            s.play.stream().map(this.anims::get).filter(e -> e != null).forEach(a -> {
                a.triggerID = id;
            });
            if (trigs.size() != 1) {
                if (trigs.isEmpty()) {
                    throw new ExportException(new FormatText("error.cpm.stagingMissingMain", Stream.concat(s.setup.stream(), s.finish.stream()).map(e -> e.toString()).findFirst().orElse("??")));
                }
                String anims = Stream.concat(s.setup.stream(), s.finish.stream()).map(e -> "'" + e + "'").collect(Collectors.joining("\\"));
                String info = s.play.stream().map(e -> Pair.of(e, this.an.getTriggers().get(this.animTriggers.get(e)))).filter(e -> e.getValue() != null).collect(Collectors.groupingBy(Pair::getValue)).values().stream().map(l -> l.stream().map(p -> "'" + p.getKey() + "'").collect(Collectors.joining("\\"))).collect(Collectors.joining("\\----\\", "----\\", ""));
                throw new ExportException(new FormatText("error.cpm.stagingMultipleMain", anims, info));
            }
            s.triggerId = this.triggers.get(trigs.get(0));
            ((SerializedTrigger)trigs.get((int)0)).mustFinish = false;
            this.an.getStagedList().add(s.triggerId);
        });
        this.dropdownParams.forEach((g, p) -> {
            EditorAnim defV = this.editor.animations.stream().filter(e -> g.equals(e.group) && e.layerDefault > 0.5f).findFirst().orElse(null);
            if (defV != null) {
                this.paramAlloc.setDefaultValue((int)p, this.dropdownAnims.get(defV));
            }
        });
    }

    private ParameterInfo makeButtonInfo(EditorAnim a) {
        switch (a.type) {
            case CUSTOM_POSE: 
            case GESTURE: {
                CustomPoseGestureButtonData dt = new CustomPoseGestureButtonData(a.type == AnimationType.CUSTOM_POSE);
                dt.setName(a.getId());
                dt.id = a.type == AnimationType.CUSTOM_POSE ? this.paramAlloc.newPose(a.getId()) : this.paramAlloc.newGesture(a.getId());
                dt.layerCtrl = a.layerControlled;
                dt.hidden = a.hidden;
                ParameterInfo param = new ParameterInfo((AbstractGestureButtonData.AbstractCommandTriggerableData)dt, dt.id);
                this.allButtons.put(a.getId(), param);
                this.buttons.add(Pair.of(a.order, dt));
                return param;
            }
            case LAYER: {
                if (a.group != null) {
                    if (!this.allButtons.containsKey(a.group)) {
                        DropdownButtonData dt = new DropdownButtonData();
                        dt.parameter = this.paramAlloc.allocByteSync(a.group, (byte)0);
                        dt.setName(a.group);
                        dt.add("");
                        ParameterInfo param = new ParameterInfo(dt, dt.parameter, 0, false);
                        this.allButtons.put(a.group, param);
                        this.buttons.add(Pair.of(a.order, dt));
                        this.dropdownParams.put(a.group, dt.parameter);
                    }
                    ParameterInfo info = this.allButtons.get(a.group);
                    if (!(info.button instanceof DropdownButtonData)) {
                        throw new RuntimeException("Animation name conflict " + a.group);
                    }
                    DropdownButtonData dt = (DropdownButtonData)info.button;
                    int id = dt.add(a.getId());
                    ParameterInfo pr = new ParameterInfo(dt, dt.parameter, id, false);
                    this.allButtons.put(a.getId(), pr);
                    this.dropdownAnims.put(a, id);
                    return pr;
                }
                BoolParameterToggleButtonData dt = new BoolParameterToggleButtonData();
                ParameterDetails.ParameterAllocator.BitInfo bit = this.paramAlloc.allocBitSync(a.getId(), a.layerDefault > 0.5f);
                dt.setInfo(bit);
                dt.setName(a.getId());
                dt.hidden = a.hidden;
                ParameterInfo param = new ParameterInfo((AbstractGestureButtonData.AbstractCommandTriggerableData)dt, bit);
                this.allButtons.put(a.getId(), param);
                this.buttons.add(Pair.of(a.order, dt));
                return param;
            }
            case VALUE_LAYER: {
                ValueParameterButtonData dt = new ValueParameterButtonData();
                dt.setName(a.getId());
                dt.parameter = this.paramAlloc.allocByteSync(a.getId(), (byte)(a.layerDefault * 255.0f));
                dt.maxValue = a.maxValue;
                dt.hidden = a.hidden;
                ParameterInfo param = new ParameterInfo(dt, dt.parameter, a.interpolateValue);
                this.allButtons.put(a.getId(), param);
                this.buttons.add(Pair.of(a.order, dt));
                return param;
            }
        }
        return null;
    }

    public static class ParameterInfo {
        public AbstractGestureButtonData.AbstractCommandTriggerableData button;
        public int parameter;
        public int value;
        public boolean bitMask;
        public boolean interpolate;

        public ParameterInfo(AbstractGestureButtonData.AbstractCommandTriggerableData button, int id) {
            this.button = button;
            this.value = id;
        }

        public ParameterInfo(AbstractGestureButtonData.AbstractCommandTriggerableData button, int parameter, boolean interpolate) {
            this.button = button;
            this.parameter = parameter;
            this.interpolate = interpolate;
        }

        public ParameterInfo(AbstractGestureButtonData.AbstractCommandTriggerableData button, int parameter, int value, boolean bitMask) {
            this.button = button;
            this.parameter = parameter;
            this.value = value;
            this.bitMask = bitMask;
        }

        public ParameterInfo(AbstractGestureButtonData.AbstractCommandTriggerableData button, ParameterDetails.ParameterAllocator.BitInfo bit) {
            this(button, bit.param, bit.mask, true);
        }

        public void apply(SerializedTrigger st) {
            st.parameter = this.parameter;
            st.value = this.value;
            st.bitMask = this.bitMask;
            st.parameterInterpolate = this.interpolate;
        }
    }

    private static class Staging {
        public int id;
        public Set<EditorAnim> setup = new HashSet<EditorAnim>();
        public Set<EditorAnim> play = new HashSet<EditorAnim>();
        public Set<EditorAnim> finish = new HashSet<EditorAnim>();
        public int triggerId;

        private Staging() {
        }
    }
}

