/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.tom.cpl.text.FormatText;
import com.tom.cpm.CustomPlayerModels;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.ModelTexture;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.common.PlayerAnimUpdater;
import com.tom.cpm.mixinplugin.Iris7Detector;
import com.tom.cpm.mixinplugin.IrisDetector;
import com.tom.cpm.mixinplugin.OFDetector;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.RenderManager;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.Log;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public abstract class ClientBase {
    public static final ResourceLocation DEFAULT_CAPE = new ResourceLocation("cpm:textures/template/cape.png");
    public static boolean optifineLoaded;
    public static boolean irisLoaded;
    public static boolean vrLoaded;
    public static MinecraftObject mc;
    protected Minecraft minecraft;
    public RenderManager<GameProfile, Player, Model, MultiBufferSource> manager;
    public NetHandler<ResourceLocation, Player, ClientPacketListener> netHandler;

    public void init0() {
        this.minecraft = Minecraft.m_91087_();
        mc = new MinecraftObject(this.minecraft);
        optifineLoaded = OFDetector.doApply();
        vrLoaded = Platform.isModLoaded("vivecraft");
        boolean bl = irisLoaded = Iris7Detector.doApply() || IrisDetector.doApply();
        if (optifineLoaded) {
            Log.info("Optifine detected, enabling optifine compatibility");
        }
        if (vrLoaded) {
            Log.info("ViveCraft detected, enabling ViveCraft compatibility");
        }
        if (irisLoaded) {
            Log.info("Iris detected, enabling iris compatibility");
        }
    }

    public void init1() {
        this.manager = new RenderManager<GameProfile, Player, Model, MultiBufferSource>(mc.getPlayerRenderManager(), mc.getDefinitionLoader(), PlayerProfile::getPlayerProfile);
        this.manager.setGPGetters(GameProfile::getProperties, Property::getValue);
        this.netHandler = new NetHandler(ResourceLocation::new);
        this.netHandler.setExecutor(() -> this.minecraft);
        this.netHandler.setSendPacketClient(d -> new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])d)), (c, rl, pb) -> c.m_104955_((Packet)new ServerboundCustomPayloadPacket(rl, pb)));
        this.netHandler.setPlayerToLoader(Player::m_36316_);
        this.netHandler.setGetPlayerById(id -> {
            Entity ent = Minecraft.m_91087_().f_91073_.m_6815_(id);
            if (ent instanceof Player) {
                return (Player)ent;
            }
            return null;
        });
        this.netHandler.setGetClient(() -> this.minecraft.f_91074_);
        this.netHandler.setGetNet(c -> ((LocalPlayer)c).f_108617_);
        this.netHandler.setDisplayText(t -> this.minecraft.f_91074_.m_5661_((Component)t.remap(), false));
        this.netHandler.setGetPlayerAnimGetters(new PlayerAnimUpdater());
    }

    public static void apiInit() {
        CustomPlayerModels.api.buildClient().voicePlayer(Player.class, Entity::m_20148_).renderApi(Model.class, ResourceLocation.class, RenderType.class, MultiBufferSource.class, GameProfile.class, ModelTexture::new).localModelApi(GameProfile::new).init();
    }

    public static void renderCape(PoseStack matrixStack, VertexConsumer buffer, int packedLightIn, AbstractClientPlayer abstractClientPlayerEntity, float partialTicks, PlayerModel<AbstractClientPlayer> model, ModelDefinition modelDefinition) {
        float s;
        float r;
        float q;
        matrixStack.m_85836_();
        if (abstractClientPlayerEntity != null) {
            double d = Mth.m_14139_((double)partialTicks, (double)abstractClientPlayerEntity.f_36102_, (double)abstractClientPlayerEntity.f_36105_) - Mth.m_14139_((double)partialTicks, (double)abstractClientPlayerEntity.f_19854_, (double)abstractClientPlayerEntity.m_20185_());
            double e = Mth.m_14139_((double)partialTicks, (double)abstractClientPlayerEntity.f_36103_, (double)abstractClientPlayerEntity.f_36106_) - Mth.m_14139_((double)partialTicks, (double)abstractClientPlayerEntity.f_19855_, (double)abstractClientPlayerEntity.m_20186_());
            double m = Mth.m_14139_((double)partialTicks, (double)abstractClientPlayerEntity.f_36104_, (double)abstractClientPlayerEntity.f_36075_) - Mth.m_14139_((double)partialTicks, (double)abstractClientPlayerEntity.f_19856_, (double)abstractClientPlayerEntity.m_20189_());
            float n = abstractClientPlayerEntity.f_20884_ + (abstractClientPlayerEntity.f_20883_ - abstractClientPlayerEntity.f_20884_);
            double o = Mth.m_14031_((float)(n * ((float)Math.PI / 180)));
            double p = -Mth.m_14089_((float)(n * ((float)Math.PI / 180)));
            q = (float)e * 10.0f;
            q = Mth.m_14036_((float)q, (float)-6.0f, (float)32.0f);
            r = (float)(d * o + m * p) * 100.0f;
            r = Mth.m_14036_((float)r, (float)0.0f, (float)150.0f);
            s = (float)(d * p - m * o) * 100.0f;
            s = Mth.m_14036_((float)s, (float)-20.0f, (float)20.0f);
            if (r < 0.0f) {
                r = 0.0f;
            }
            float t = Mth.m_14179_((float)partialTicks, (float)abstractClientPlayerEntity.f_36099_, (float)abstractClientPlayerEntity.f_36100_);
            q += Mth.m_14031_((float)(Mth.m_14179_((float)partialTicks, (float)abstractClientPlayerEntity.f_19867_, (float)abstractClientPlayerEntity.f_19787_) * 6.0f)) * 32.0f * t;
            if (abstractClientPlayerEntity.m_6047_()) {
                q += 50.0f;
            }
            if (abstractClientPlayerEntity.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
                if (abstractClientPlayerEntity.m_6047_()) {
                    model.f_103373_.f_104202_ = 1.775f;
                    model.f_103373_.f_104201_ = 2.35f;
                } else {
                    model.f_103373_.f_104202_ = 2.0f;
                    model.f_103373_.f_104201_ = 0.0f;
                }
            } else if (abstractClientPlayerEntity.m_6047_()) {
                model.f_103373_.f_104202_ = 2.3f;
                model.f_103373_.f_104201_ = 1.1f;
            } else {
                model.f_103373_.f_104202_ = 2.9f;
                model.f_103373_.f_104201_ = 0.14999998f;
            }
        } else {
            r = 0.0f;
            q = 0.0f;
            s = 0.0f;
        }
        model.f_103373_.f_104203_ = (float)(-Math.toRadians(6.0f + q / 2.0f + r));
        model.f_103373_.f_104204_ = (float)Math.toRadians(180.0f - s / 2.0f);
        model.f_103373_.f_104205_ = (float)Math.toRadians(s / 2.0f);
        mc.getPlayerRenderManager().setModelPose(model);
        model.f_103373_.f_104203_ = 0.0f;
        model.f_103373_.f_104204_ = 0.0f;
        model.f_103373_.f_104205_ = 0.0f;
        model.m_103411_(matrixStack, buffer, packedLightIn, OverlayTexture.f_118083_);
        matrixStack.m_85849_();
    }

    public <E extends Entity> void renderNameTag(PlayerNameTagRenderer<E> r, E entityIn, GameProfile gprofile, String unique, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        FormatText st;
        double d0 = r.cpm$entityRenderDispatcher().m_114471_(entityIn);
        if (d0 < 100.0 && (st = this.manager.getStatus(gprofile, unique)) != null) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.0, (double)1.3f, 0.0);
            matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
            r.cpm$renderNameTag(entityIn, (Component)st.remap(), matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.m_85849_();
        }
    }

    public void playerRenderPre(Player player, MultiBufferSource buffer, PlayerModel model) {
        this.manager.bindPlayer(player, buffer, (Model)model);
    }

    public void playerRenderPost(MultiBufferSource buffer, PlayerModel model) {
        this.manager.unbindClear((Model)model);
    }

    public void renderHand(MultiBufferSource buffer, PlayerModel model) {
        this.manager.bindHand((Player)this.minecraft.f_91074_, buffer, (Model)model);
    }

    public void renderHandPost(MultiBufferSource buffer, HumanoidModel model) {
        this.manager.unbindClear((Model)model);
    }

    public void renderSkull(Model skullModel, GameProfile profile, MultiBufferSource buffer) {
        this.manager.bindSkull(profile, buffer, skullModel);
    }

    public void renderSkullPost(MultiBufferSource buffer, Model model) {
        this.manager.unbindFlush(model);
    }

    public void renderElytra(HumanoidModel<LivingEntity> player, ElytraModel<LivingEntity> model) {
        this.manager.bindElytra((Model)player, (Model)model);
    }

    public void renderArmor(HumanoidModel<LivingEntity> modelArmor, HumanoidModel<LivingEntity> modelLeggings, HumanoidModel<LivingEntity> player) {
        this.manager.bindArmor((Model)player, (Model)modelArmor, 1);
        this.manager.bindArmor((Model)player, (Model)modelLeggings, 2);
    }

    public void updateJump() {
        if (this.minecraft.f_91074_.m_20096_() && this.minecraft.f_91074_.f_108618_.f_108572_) {
            this.manager.jump((Player)this.minecraft.f_91074_);
        }
    }

    public void registerShaders(ShaderLoader loader) {
    }

    public static interface PlayerNameTagRenderer<E extends Entity> {
        public void cpm$renderNameTag(E var1, Component var2, PoseStack var3, MultiBufferSource var4, int var5);

        public EntityRenderDispatcher cpm$entityRenderDispatcher();
    }

    public static interface ShaderLoader {
        public void cpm$registerShader(String var1, VertexFormat var2, Consumer<ShaderInstance> var3);
    }
}

