/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import software.bernie.geckolib.animatable.stateless.StatelessGeoSingletonAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.util.NetworkUtil;

public class StatelessSingletonPlayAnimPacket {
    private final String syncableId;
    private final long instanceId;
    private final RawAnimation animation;

    public StatelessSingletonPlayAnimPacket(String syncableId, long instanceId, RawAnimation animation) {
        this.syncableId = syncableId;
        this.instanceId = instanceId;
        this.animation = animation;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.syncableId);
        buffer.m_130103_(this.instanceId);
        NetworkUtil.writeRawAnimationToBuffer(this.animation, buffer);
    }

    public static StatelessSingletonPlayAnimPacket decode(FriendlyByteBuf buffer) {
        String syncableId = buffer.m_130277_();
        long instanceID = buffer.m_130258_();
        RawAnimation animation = NetworkUtil.readRawAnimationFromBuffer(buffer);
        return new StatelessSingletonPlayAnimPacket(syncableId, instanceID, animation);
    }

    public void receivePacket(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context handler = context.get();
        handler.enqueueWork(() -> {
            GeoAnimatable animatable = GeckoLibNetwork.getSyncedAnimatable(this.syncableId);
            if (animatable instanceof StatelessGeoSingletonAnimatable) {
                StatelessGeoSingletonAnimatable statelessAnimatable = (StatelessGeoSingletonAnimatable)animatable;
                statelessAnimatable.handleClientAnimationPlay(animatable, this.instanceId, this.animation);
            }
        });
    }
}

