/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import squeek.appleskin.ModConfig;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.event.TooltipOverlayEvent;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.KeyHelper;
import squeek.appleskin.helpers.TextureHelper;

@OnlyIn(value=Dist.CLIENT)
public class TooltipOverlayHandler {
    public static final int TOOLTIP_REAL_HEIGHT_OFFSET_BOTTOM = 3;
    public static final int TOOLTIP_REAL_HEIGHT_OFFSET_TOP = -3;
    public static final int TOOLTIP_REAL_WIDTH_OFFSET_RIGHT = 3;
    private static final TextureOffsets normalBarTextureOffsets = new TextureOffsets();
    private static final TextureOffsets rottenBarTextureOffsets;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new TooltipOverlayHandler());
    }

    public static void register(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(FoodTooltip.class, FoodTooltipRenderer::new);
    }

    @SubscribeEvent
    public void gatherTooltips(RenderTooltipEvent.GatherComponents event) {
        if (event.isCanceled()) {
            return;
        }
        ItemStack hoveredStack = event.getItemStack();
        Minecraft mc = Minecraft.m_91087_();
        if (!TooltipOverlayHandler.shouldShowTooltip(hoveredStack, (Player)mc.f_91074_)) {
            return;
        }
        FoodValues defaultFood = FoodHelper.getDefaultFoodValues(hoveredStack, (Player)mc.f_91074_);
        FoodValues modifiedFood = FoodHelper.getModifiedFoodValues(hoveredStack, (Player)mc.f_91074_);
        FoodValuesEvent foodValuesEvent = new FoodValuesEvent((Player)mc.f_91074_, hoveredStack, defaultFood, modifiedFood);
        MinecraftForge.EVENT_BUS.post((Event)foodValuesEvent);
        defaultFood = foodValuesEvent.defaultFoodValues;
        modifiedFood = foodValuesEvent.modifiedFoodValues;
        TooltipOverlayEvent.Pre prerenderEvent = new TooltipOverlayEvent.Pre(hoveredStack, defaultFood, modifiedFood);
        MinecraftForge.EVENT_BUS.post((Event)prerenderEvent);
        if (prerenderEvent.isCanceled()) {
            return;
        }
        FoodTooltip foodTooltip = new FoodTooltip(prerenderEvent.itemStack, defaultFood, modifiedFood, (Player)mc.f_91074_);
        if (foodTooltip.shouldRenderHungerBars()) {
            event.getTooltipElements().add(Either.right((Object)foodTooltip));
        }
    }

    private static boolean shouldShowTooltip(ItemStack hoveredStack, Player player) {
        boolean shouldShowTooltip;
        if (hoveredStack.m_41619_()) {
            return false;
        }
        boolean bl = shouldShowTooltip = (Boolean)ModConfig.SHOW_FOOD_VALUES_IN_TOOLTIP.get() != false && KeyHelper.isShiftKeyDown() || (Boolean)ModConfig.ALWAYS_SHOW_FOOD_VALUES_TOOLTIP.get() != false;
        if (!shouldShowTooltip) {
            return false;
        }
        return FoodHelper.isFood(hoveredStack, player);
    }

    static {
        TooltipOverlayHandler.normalBarTextureOffsets.containerNegativeHunger = 43;
        TooltipOverlayHandler.normalBarTextureOffsets.containerExtraHunger = 133;
        TooltipOverlayHandler.normalBarTextureOffsets.containerNormalHunger = 16;
        TooltipOverlayHandler.normalBarTextureOffsets.containerPartialHunger = 124;
        TooltipOverlayHandler.normalBarTextureOffsets.containerMissingHunger = 34;
        TooltipOverlayHandler.normalBarTextureOffsets.shankMissingFull = 70;
        TooltipOverlayHandler.normalBarTextureOffsets.shankMissingPartial = TooltipOverlayHandler.normalBarTextureOffsets.shankMissingFull + 9;
        TooltipOverlayHandler.normalBarTextureOffsets.shankFull = 52;
        TooltipOverlayHandler.normalBarTextureOffsets.shankPartial = TooltipOverlayHandler.normalBarTextureOffsets.shankFull + 9;
        rottenBarTextureOffsets = new TextureOffsets();
        TooltipOverlayHandler.rottenBarTextureOffsets.containerNegativeHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerNegativeHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerExtraHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerExtraHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerNormalHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerNormalHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerPartialHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerPartialHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerMissingHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerMissingHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingFull = 106;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingPartial = TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingFull + 9;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankFull = 88;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankPartial = TooltipOverlayHandler.rottenBarTextureOffsets.shankFull + 9;
    }

    static class FoodTooltip
    implements TooltipComponent {
        private FoodValues defaultFood;
        private FoodValues modifiedFood;
        private int biggestHunger;
        private float biggestSaturationIncrement;
        private int hungerBars;
        private String hungerBarsText;
        private int saturationBars;
        private String saturationBarsText;
        private ItemStack itemStack;

        FoodTooltip(ItemStack itemStack, FoodValues defaultFood, FoodValues modifiedFood, Player player) {
            this.itemStack = itemStack;
            this.defaultFood = defaultFood;
            this.modifiedFood = modifiedFood;
            this.biggestHunger = Math.max(defaultFood.hunger, modifiedFood.hunger);
            this.biggestSaturationIncrement = Math.max(defaultFood.getSaturationIncrement(), modifiedFood.getSaturationIncrement());
            this.hungerBars = (int)Math.ceil((float)Math.abs(this.biggestHunger) / 2.0f);
            if (this.hungerBars > 10) {
                this.hungerBarsText = "x" + (this.biggestHunger < 0 ? -1 : 1) * this.hungerBars;
                this.hungerBars = 1;
            }
            this.saturationBars = (int)Math.ceil(Math.abs(this.biggestSaturationIncrement) / 2.0f);
            if (this.saturationBars > 10 || this.saturationBars == 0) {
                this.saturationBarsText = "x" + (this.biggestSaturationIncrement < 0.0f ? -1 : 1) * this.saturationBars;
                this.saturationBars = 1;
            }
        }

        boolean shouldRenderHungerBars() {
            return this.hungerBars > 0;
        }
    }

    static class TextureOffsets {
        int containerNegativeHunger;
        int containerExtraHunger;
        int containerNormalHunger;
        int containerPartialHunger;
        int containerMissingHunger;
        int shankMissingFull;
        int shankMissingPartial;
        int shankFull;
        int shankPartial;

        TextureOffsets() {
        }
    }

    static class FoodTooltipRenderer
    implements ClientTooltipComponent {
        private FoodTooltip foodTooltip;

        FoodTooltipRenderer(FoodTooltip foodTooltip) {
            this.foodTooltip = foodTooltip;
        }

        public int m_142103_() {
            return 20;
        }

        public int m_142069_(Font font) {
            int hungerBarsWidth = this.foodTooltip.hungerBars * 9;
            if (this.foodTooltip.hungerBarsText != null) {
                hungerBarsWidth += font.m_92895_(this.foodTooltip.hungerBarsText);
            }
            int saturationBarsWidth = this.foodTooltip.saturationBars * 7;
            if (this.foodTooltip.saturationBarsText != null) {
                saturationBarsWidth += font.m_92895_(this.foodTooltip.saturationBarsText);
            }
            return Math.max(hungerBarsWidth, saturationBarsWidth) + 2;
        }

        public void m_183452_(Font font, int x, int y, GuiGraphics guiGraphics) {
            ItemStack itemStack = this.foodTooltip.itemStack;
            Minecraft mc = Minecraft.m_91087_();
            if (!TooltipOverlayHandler.shouldShowTooltip(itemStack, (Player)mc.f_91074_)) {
                return;
            }
            Screen gui = mc.f_91080_;
            if (gui == null) {
                return;
            }
            FoodValues defaultFood = this.foodTooltip.defaultFood;
            FoodValues modifiedFood = this.foodTooltip.modifiedFood;
            TooltipOverlayEvent.Render renderEvent = new TooltipOverlayEvent.Render(itemStack, x, y, guiGraphics, defaultFood, modifiedFood);
            MinecraftForge.EVENT_BUS.post((Event)renderEvent);
            if (renderEvent.isCanceled()) {
                return;
            }
            x = renderEvent.x;
            y = renderEvent.y;
            guiGraphics = renderEvent.guiGraphics;
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int offsetX = x;
            int offsetY = y;
            int defaultHunger = defaultFood.hunger;
            int modifiedHunger = modifiedFood.hunger;
            offsetX += (this.foodTooltip.hungerBars - 1) * 9;
            TextureOffsets offsets = FoodHelper.isRotten(itemStack, (Player)mc.f_91074_) ? rottenBarTextureOffsets : normalBarTextureOffsets;
            for (int i = 0; i < this.foodTooltip.hungerBars * 2; i += 2) {
                if (modifiedHunger < 0) {
                    guiGraphics.m_280398_(TextureHelper.MC_ICONS, offsetX, offsetY, 0, (float)offsets.containerNegativeHunger, 27.0f, 9, 9, 256, 256);
                } else if (modifiedHunger > defaultHunger && defaultHunger <= i) {
                    guiGraphics.m_280398_(TextureHelper.MC_ICONS, offsetX, offsetY, 0, (float)offsets.containerExtraHunger, 27.0f, 9, 9, 256, 256);
                } else if (modifiedHunger > i + 1 || defaultHunger == modifiedHunger) {
                    guiGraphics.m_280398_(TextureHelper.MC_ICONS, offsetX, offsetY, 0, (float)offsets.containerNormalHunger, 27.0f, 9, 9, 256, 256);
                } else if (modifiedHunger == i + 1) {
                    guiGraphics.m_280398_(TextureHelper.MC_ICONS, offsetX, offsetY, 0, (float)offsets.containerPartialHunger, 27.0f, 9, 9, 256, 256);
                } else {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    guiGraphics.m_280398_(TextureHelper.MC_ICONS, offsetX, offsetY, 0, (float)offsets.containerMissingHunger, 27.0f, 9, 9, 256, 256);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
                guiGraphics.m_280398_(TextureHelper.MC_ICONS, offsetX, offsetY, 0, defaultHunger - 1 == i ? (float)offsets.shankMissingPartial : (float)offsets.shankMissingFull, 27.0f, 9, 9, 256, 256);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (modifiedHunger > i) {
                    guiGraphics.m_280398_(TextureHelper.MC_ICONS, offsetX, offsetY, 0, modifiedHunger - 1 == i ? (float)offsets.shankPartial : (float)offsets.shankFull, 27.0f, 9, 9, 256, 256);
                }
                offsetX -= 9;
            }
            if (this.foodTooltip.hungerBarsText != null) {
                PoseStack poseStack = guiGraphics.m_280168_();
                poseStack.m_85836_();
                poseStack.m_252880_((float)(offsetX += 18), (float)offsetY, 0.0f);
                poseStack.m_85841_(0.75f, 0.75f, 0.75f);
                guiGraphics.m_280488_(font, this.foodTooltip.hungerBarsText, 2, 2, -5592406);
                poseStack.m_85849_();
            }
            offsetX = x;
            offsetY += 10;
            float modifiedSaturationIncrement = modifiedFood.getSaturationIncrement();
            float absModifiedSaturationIncrement = Math.abs(modifiedSaturationIncrement);
            offsetX += (this.foodTooltip.saturationBars - 1) * 7;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int i = 0; i < this.foodTooltip.saturationBars * 2; i += 2) {
                boolean shouldBeFaded;
                float effectiveSaturationOfBar = (absModifiedSaturationIncrement - (float)i) / 2.0f;
                boolean bl = shouldBeFaded = absModifiedSaturationIncrement <= (float)i;
                if (shouldBeFaded) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                }
                guiGraphics.m_280398_(TextureHelper.MOD_ICONS, offsetX, offsetY, 0, effectiveSaturationOfBar >= 1.0f ? 21.0f : ((double)effectiveSaturationOfBar > 0.5 ? 14.0f : ((double)effectiveSaturationOfBar > 0.25 ? 7.0f : (effectiveSaturationOfBar > 0.0f ? 0.0f : 28.0f))), modifiedSaturationIncrement >= 0.0f ? 27.0f : 34.0f, 7, 7, 256, 256);
                if (shouldBeFaded) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                offsetX -= 7;
            }
            if (this.foodTooltip.saturationBarsText != null) {
                PoseStack poseStack = guiGraphics.m_280168_();
                poseStack.m_85836_();
                poseStack.m_252880_((float)(offsetX += 14), (float)offsetY, 0.0f);
                poseStack.m_85841_(0.75f, 0.75f, 0.75f);
                guiGraphics.m_280488_(font, this.foodTooltip.saturationBarsText, 2, 1, -5592406);
                poseStack.m_85849_();
            }
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureHelper.MC_ICONS);
            RenderSystem.disableDepthTest();
        }
    }
}

