/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.neoforge.config;

import betteradvancements.common.advancements.BetterDisplayInfo;
import betteradvancements.common.gui.BetterAdvancementTab;
import betteradvancements.common.gui.BetterAdvancementTabType;
import betteradvancements.common.gui.BetterAdvancementsScreen;
import betteradvancements.common.gui.BetterAdvancementsScreenButton;
import betteradvancements.common.util.ColorHelper;
import betteradvancements.common.util.CriteriaDetail;
import betteradvancements.common.util.CriterionGrid;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigValues {
    public static ForgeConfigSpec.ConfigValue<String> defaultUncompletedIconColor;
    public static ForgeConfigSpec.ConfigValue<String> defaultUncompletedTitleColor;
    public static ForgeConfigSpec.ConfigValue<String> defaultCompletedIconColor;
    public static ForgeConfigSpec.ConfigValue<String> defaultCompletedTitleColor;
    public static ForgeConfigSpec.BooleanValue doFade;
    public static ForgeConfigSpec.BooleanValue showDebugCoordinates;
    public static ForgeConfigSpec.BooleanValue orderTabsAlphabetically;
    public static ForgeConfigSpec.IntValue uiScaling;
    public static ForgeConfigSpec.ConfigValue<String> detailLevel;
    public static ForgeConfigSpec.BooleanValue requiresShift;
    public static ForgeConfigSpec.BooleanValue addToInventory;
    public static ForgeConfigSpec.BooleanValue defaultDrawDirectLines;
    public static ForgeConfigSpec.BooleanValue defaultHideLines;
    public static ForgeConfigSpec.ConfigValue<String> defaultCompletedLineColor;
    public static ForgeConfigSpec.ConfigValue<String> defaultUncompletedLineColor;
    public static ForgeConfigSpec.BooleanValue onlyUseAboveAdvancementTabs;

    public static ForgeConfigSpec build() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        defaultUncompletedIconColor = builder.define("defaultUncompletedIconColor", (Object)"#FFFFFF");
        defaultUncompletedTitleColor = builder.define("defaultUncompletedTitleColor", (Object)"#0489C1");
        defaultCompletedIconColor = builder.define("defaultCompletedIconColor", (Object)"#DBA213");
        defaultCompletedTitleColor = builder.define("defaultCompletedTitleColor", (Object)"#DBA213");
        doFade = builder.define("doAdvancementsBackgroundFade", true);
        showDebugCoordinates = builder.define("showDebugCoordinates", false);
        orderTabsAlphabetically = builder.define("orderTabsAlphabetically", false);
        uiScaling = builder.comment("Values below 50% might give odd results, use on own risk ;)").defineInRange("uiScaling", 100, 1, 100);
        detailLevel = builder.comment(CriteriaDetail.comments()).defineInList("criteriaDetail", (Object)CriteriaDetail.DEFAULT.getName(), CriteriaDetail.names());
        requiresShift = builder.define("criteriaDetailRequiresShift", false);
        addToInventory = builder.define("addInventoryButton", false);
        defaultDrawDirectLines = builder.define("defaultDrawDirectLines", false);
        defaultHideLines = builder.define("defaultHideLines", false);
        defaultCompletedLineColor = builder.define("defaultCompletedLineColor", (Object)"#FFFFFF");
        defaultUncompletedLineColor = builder.define("defaultUncompletedLineColor", (Object)"#FFFFFF");
        onlyUseAboveAdvancementTabs = builder.define("onlyUseAboveAdvancementTabs", false);
        return builder.build();
    }

    public static void pushChanges() {
        BetterDisplayInfo.defaultUncompletedIconColor = ColorHelper.RGB((String)defaultUncompletedIconColor.get());
        BetterDisplayInfo.defaultUncompletedTitleColor = ColorHelper.RGB((String)defaultUncompletedTitleColor.get());
        BetterDisplayInfo.defaultCompletedIconColor = ColorHelper.RGB((String)defaultCompletedIconColor.get());
        BetterDisplayInfo.defaultCompletedTitleColor = ColorHelper.RGB((String)defaultCompletedTitleColor.get());
        BetterAdvancementTab.doFade = (Boolean)doFade.get();
        BetterAdvancementsScreen.showDebugCoordinates = (Boolean)showDebugCoordinates.get();
        BetterAdvancementsScreen.orderTabsAlphabetically = (Boolean)orderTabsAlphabetically.get();
        BetterAdvancementsScreen.uiScaling = (Integer)uiScaling.get();
        CriterionGrid.detailLevel = CriteriaDetail.fromName((String)detailLevel.get());
        CriterionGrid.requiresShift = (Boolean)requiresShift.get();
        BetterAdvancementsScreenButton.addToInventory = (Boolean)addToInventory.get();
        BetterDisplayInfo.defaultDrawDirectLines = (Boolean)defaultDrawDirectLines.get();
        BetterDisplayInfo.defaultHideLines = (Boolean)defaultHideLines.get();
        BetterDisplayInfo.defaultCompletedLineColor = ColorHelper.RGB((String)defaultCompletedLineColor.get());
        BetterDisplayInfo.defaultUncompletedLineColor = ColorHelper.RGB((String)defaultUncompletedLineColor.get());
        BetterAdvancementTabType.onlyUseAbove = (Boolean)onlyUseAboveAdvancementTabs.get();
    }
}

