/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.world.processor;

import com.yungnickyoung.minecraft.yungsextras.world.processor.INbtFeatureProcessor;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class DesertWellProcessor
implements INbtFeatureProcessor {
    private static final ResourceLocation EXTRA = new ResourceLocation("yungsextras", "desert/extra_archeology");

    @Override
    public void processTemplate(StructureTemplate template, WorldGenLevel level, RandomSource random, BlockPos cornerPos, BlockPos centerPos, StructurePlaceSettings placementSettings) {
        ArrayList<BlockPos> changedPositions = new ArrayList<BlockPos>();
        int maxSusSand = random.m_188503_(3) + 2;
        int susSandPlaced = 0;
        for (StructureTemplate.StructureBlockInfo blockInfo : template.m_74603_(cornerPos, placementSettings, Blocks.f_50212_)) {
            if (susSandPlaced < maxSusSand && random.m_188501_() < 0.1f) {
                this.placeSusSand(level, blockInfo.f_74675_(), BuiltInLootTables.f_276662_);
                ++susSandPlaced;
                continue;
            }
            level.m_7731_(blockInfo.f_74675_(), Blocks.f_49992_.m_49966_(), 2);
            changedPositions.add(blockInfo.f_74675_());
        }
        if (susSandPlaced < 2) {
            for (BlockPos pos : changedPositions) {
                if (susSandPlaced >= 2) break;
                this.placeSusSand(level, pos, BuiltInLootTables.f_276662_);
                ++susSandPlaced;
            }
        }
        int extraSusSand = random.m_188503_(3) + 2;
        for (StructureTemplate.StructureBlockInfo blockInfo : template.m_74603_(cornerPos, placementSettings, Blocks.f_50204_)) {
            if (extraSusSand > 0 && random.m_188501_() < 0.4f) {
                this.placeSusSand(level, blockInfo.f_74675_(), EXTRA);
                --extraSusSand;
                continue;
            }
            level.m_7731_(blockInfo.f_74675_(), Blocks.f_49992_.m_49966_(), 2);
        }
    }

    private void placeSusSand(WorldGenLevel level, BlockPos pos, ResourceLocation lootTable) {
        level.m_7731_(pos, Blocks.f_271439_.m_49966_(), 3);
        level.m_141902_(pos, BlockEntityType.f_271323_).ifPresent(blockEntity -> blockEntity.m_277049_(lootTable, pos.m_121878_()));
    }
}

