/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.repack.jcodec.scale.highbd;

import com.github.alexthe666.citadel.repack.jcodec.common.model.PictureHiBD;
import com.github.alexthe666.citadel.repack.jcodec.scale.highbd.TransformHiBD;

public class Yuv422jToYuv420pHiBD
implements TransformHiBD {
    public static int Y_COEFF = 7168;

    @Override
    public void transform(PictureHiBD src, PictureHiBD dst) {
        int[] sy = src.getPlaneData(0);
        int[] dy = dst.getPlaneData(0);
        for (int i = 0; i < src.getPlaneWidth(0) * src.getPlaneHeight(0); ++i) {
            dy[i] = (sy[i] * Y_COEFF >> 13) + 16;
        }
        this.copyAvg(src.getPlaneData(1), dst.getPlaneData(1), src.getPlaneWidth(1), src.getPlaneHeight(1));
        this.copyAvg(src.getPlaneData(2), dst.getPlaneData(2), src.getPlaneWidth(2), src.getPlaneHeight(2));
    }

    private void copyAvg(int[] src, int[] dst, int width, int height) {
        int offSrc = 0;
        int offDst = 0;
        for (int y = 0; y < height / 2; ++y) {
            int x = 0;
            while (x < width) {
                int a = ((src[offSrc] - 128) * Y_COEFF >> 13) + 128;
                int b = ((src[offSrc + width] - 128) * Y_COEFF >> 13) + 128;
                dst[offDst] = a + b + 1 >> 1;
                ++x;
                ++offDst;
                ++offSrc;
            }
            offSrc += width;
        }
    }
}

