/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.heat.stirlingengine;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.antarcticgardens.newage.content.heat.stirlingengine.StirlingEngineBlockEntity;
import org.jetbrains.annotations.Nullable;

public class StirlingEngineVisual
extends KineticBlockEntityVisual<StirlingEngineBlockEntity>
implements SimpleDynamicVisual {
    protected final RotatingInstance shaft;
    protected float lastAngle = Float.NaN;

    public StirlingEngineVisual(VisualizationContext context, StirlingEngineBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        Direction.Axis axis = this.rotationAxis();
        this.shaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstance();
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(axis).setChanged();
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        float partialTicks = ctx.partialTick();
        float speed = ((StirlingEngineBlockEntity)this.blockEntity).visualSpeed.getValue(partialTicks) * 3.0f / 10.0f;
        float angle = ((StirlingEngineBlockEntity)this.blockEntity).angle + speed * partialTicks;
        if ((double)Math.abs(angle - this.lastAngle) < 0.001) {
            return;
        }
        this.lastAngle = angle;
    }

    public void update(float pt) {
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
    }

    public void updateLight(float partialTick) {
        this.relight(this.pos, new FlatLit[]{this.shaft});
    }

    public void _delete() {
        this.shaft.delete();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.shaft);
    }
}

