/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.energiser;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyBlock;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.antarcticgardens.newage.content.energiser.EnergiserBehaviour;
import org.antarcticgardens.newage.energy.InsertOnlyResizableEnergyContainer;
import org.antarcticgardens.newage.tools.StringFormattingTool;

public class EnergiserBlockEntity
extends KineticBlockEntity
implements BotariumEnergyBlock<WrappedBlockEnergyContainer> {
    public WrappedBlockEnergyContainer energy;
    public int tier;
    public float size = 0.0f;
    private EnergiserBehaviour energisingBehaviour;
    private InsertOnlyResizableEnergyContainer mut;
    public long lastCharged = -1L;

    public EnergiserBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int tier) {
        super(type, pos, state);
        this.tier = tier;
        this.energisingBehaviour.tier = tier;
        if (this.mut == null) {
            this.getOrCreateNetwork();
        }
        this.mut.setMaxCapacity((long)(Math.pow(10.0, tier) * 1000.0));
    }

    protected AABB createRenderBoundingBox() {
        Vec3 pos = new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_());
        return new AABB(pos.m_82520_(-1.0, -3.0, -1.0), pos.m_82520_(1.0, 1.0, 1.0));
    }

    public static EnergiserBlockEntity newTier1(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        return new EnergiserBlockEntity(type, pos, state, 1);
    }

    public static EnergiserBlockEntity newTier2(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        return new EnergiserBlockEntity(type, pos, state, 2);
    }

    public static EnergiserBlockEntity newTier3(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        return new EnergiserBlockEntity(type, pos, state, 3);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.energisingBehaviour = new EnergiserBehaviour(this);
        behaviours.add((BlockEntityBehaviour)this.energisingBehaviour);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"tooltip.create_new_age.energy_stats", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_new_age.energy_stored", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_new_age.energy_storage", (Object[])new Object[]{StringFormattingTool.formatLong(this.energy.getStoredEnergy()), StringFormattingTool.formatLong(this.energy.getMaxCapacity())}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        if (this.lastCharged != -1L) {
            CreateLang.translate((String)"tooltip.create_new_age.energy_usage", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            CreateLang.translate((String)"tooltip.create_new_age.energy_per_tick", (Object[])new Object[]{StringFormattingTool.formatLong(this.lastCharged)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        WrappedBlockEnergyContainer wrappedBlockEnergyContainer;
        if (this.energy == null) {
            this.mut = new InsertOnlyResizableEnergyContainer(0L);
            wrappedBlockEnergyContainer = this.energy = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)this.mut);
        } else {
            wrappedBlockEnergyContainer = this.energy;
        }
        return wrappedBlockEnergyContainer;
    }

    public float calculateStressApplied() {
        float impact = this.tier == 1 ? 4.0f : (this.tier == 2 ? 8.0f : 32.0f);
        this.lastStressApplied = impact;
        return impact;
    }
}

