/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import javax.annotation.Nullable;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.command.client.BookCommand;
import slimeknights.mantle.command.client.MantleClientCommand;

public class ClearBookCacheCommand {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(source -> source.m_81373_() instanceof AbstractClientPlayer)).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(MantleClientCommand.REGISTERED_BOOKS).executes(ClearBookCacheCommand::runBook))).executes(ClearBookCacheCommand::runAll);
    }

    private static int runBook(CommandContext<CommandSourceStack> context) {
        ResourceLocation book = ResourceLocationArgument.m_107011_(context, (String)"id");
        ClearBookCacheCommand.clearBookCache(book);
        return 0;
    }

    private static int runAll(CommandContext<CommandSourceStack> context) {
        ClearBookCacheCommand.clearBookCache(null);
        return 0;
    }

    private static void clearBookCache(@Nullable ResourceLocation book) {
        if (book != null) {
            BookData bookData = BookLoader.getBook(book);
            if (bookData != null) {
                bookData.reset();
            } else {
                BookCommand.bookNotFound(book);
            }
        } else {
            BookLoader.resetAllBooks();
        }
    }
}

