/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book;

import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.screen.book.Textures;

public class ArrowButton
extends Button {
    public static final int WIDTH = 18;
    public static final int HEIGHT = 10;
    @Nullable
    private final BookData bookData;
    public ArrowType arrowType;
    public int color;
    public int hoverColor;

    public ArrowButton(@Nullable BookData bookData, int x, int y, ArrowType arrowType, int color, int hoverColor, Button.OnPress onPress) {
        super(x, y, arrowType.w, arrowType.h, (Component)Component.m_237119_(), onPress, Button.f_252438_);
        this.arrowType = arrowType;
        this.color = color;
        this.hoverColor = hoverColor;
        this.bookData = bookData;
    }

    public ArrowButton(int x, int y, ArrowType arrowType, int color, int hoverColor, Button.OnPress onPress) {
        this(null, x, y, arrowType, color, hoverColor, onPress);
    }

    private void renderButton(GuiGraphics graphics, @Nullable BookData bookData) {
        ResourceLocation texture = bookData != null ? bookData.appearance.getBookTexture() : Textures.TEX_BOOK;
        int color = this.f_93622_ ? this.hoverColor : this.color;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        graphics.m_280246_(r, g, b, 1.0f);
        graphics.m_280411_(texture, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, (float)this.arrowType.x, (float)this.arrowType.y, this.f_93618_, this.f_93619_, 512, 512);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderButton(GuiGraphics graphics, int mouseX, int mouseY, float pPartialTick, @Nullable BookData bookData) {
        this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
        this.renderButton(graphics, bookData);
    }

    protected void m_87963_(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderButton(graphics, this.bookData);
    }

    public static enum ArrowType {
        NEXT(412, 0),
        PREV(412, 10),
        RIGHT(412, 20),
        LEFT(412, 30),
        BACK_UP(412, 40, 18, 18),
        UP(412, 58, 10, 18),
        DOWN(422, 58, 10, 18),
        REFRESH(412, 76, 18, 18);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private ArrowType(int x, int y) {
            this(x, y, 18, 10);
        }

        private ArrowType(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

