/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.portal;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2424;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2632;
import net.minecraft.class_2673;
import net.minecraft.class_2680;
import net.minecraft.class_2696;
import net.minecraft.class_2724;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2783;
import net.minecraft.class_2784;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_4048;
import net.minecraft.class_4543;
import net.minecraft.class_5217;
import net.minecraft.class_5454;
import net.minecraft.class_5459;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.advancements.BECriteria;
import org.betterx.betterend.portal.PortalBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TravelerState {
    public final class_1297 entity;
    private class_2338 portalEntrancePos;
    private boolean isInsidePortal;
    private int portalTime;

    public TravelerState(class_1297 entity) {
        this.entity = entity;
        this.portalEntrancePos = null;
        this.isInsidePortal = false;
    }

    public static TravelerState init(class_1297 e) {
        return new TravelerState(e);
    }

    public void handleInsidePortal(class_2338 blockPos) {
        if (this.entity.method_30230()) {
            this.entity.method_30229();
            return;
        }
        if (!this.level().field_9236 && !blockPos.equals((Object)this.portalEntrancePos)) {
            this.portalEntrancePos = blockPos.method_10062();
        }
        if (this.level().field_9236 && this.entity instanceof class_746) {
            this.entity.field_5963 = true;
        }
        this.isInsidePortal = true;
    }

    public class_1937 level() {
        return this.entity.method_37908();
    }

    @ApiStatus.Internal
    public void portalTick() {
        if (!(this.level() instanceof class_3218)) {
            return;
        }
        if (this.isInsidePortal) {
            int waitTimer = this.entity.method_5741();
            class_3218 sourceDimension = (class_3218)this.level();
            MinecraftServer minecraftServer = sourceDimension.method_8503();
            class_3218 targetDimension = minecraftServer.method_3847(this.level().method_27983() == class_1937.field_25181 ? class_1937.field_25179 : class_1937.field_25181);
            if (targetDimension != null && !this.entity.method_5765() && this.portalTime++ >= waitTimer) {
                this.level().method_16107().method_15396("end_portal");
                this.portalTime = waitTimer;
                this.entity.method_30229();
                this.changeDimension(targetDimension);
                this.level().method_16107().method_15407();
            }
            this.isInsidePortal = false;
        } else {
            if (this.portalTime > 0) {
                this.portalTime -= 4;
            }
            if (this.portalTime < 0) {
                this.portalTime = 0;
            }
        }
    }

    @Nullable
    public void changeDimension(class_3218 targetLevel) {
        if (!(this.level() instanceof class_3218) || this.entity.method_31481()) {
            return;
        }
        this.level().method_16107().method_15396("be_findEntry");
        this.entity.method_18375();
        class_5454 portalInfo = this.findDimensionEntryPoint(targetLevel);
        if (portalInfo == null) {
            return;
        }
        this.level().method_16107().method_15396("be_reposition");
        this.teleportEntity(targetLevel, portalInfo);
        this.level().method_16107().method_15407();
        this.level().method_16107().method_15407();
    }

    private void teleportEntity(class_3218 serverLevel, class_5454 portalInfo) {
        class_3222 sp;
        boolean targetIsEnd = serverLevel.method_27983().equals(class_1937.field_25181);
        MinecraftServer server = serverLevel.method_8503();
        class_3218 destination = targetIsEnd ? server.method_3847(class_1937.field_25181) : server.method_3847(class_1937.field_25179);
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_3222 && (sp = (class_3222)class_12972).method_7337()) {
            sp.method_14251(destination, portalInfo.field_25879.field_1352 + 0.5, portalInfo.field_25879.field_1351, portalInfo.field_25879.field_1350 + 0.5, this.entity.method_36454() + 180.0f, this.entity.method_36455());
            BECriteria.PORTAL_TRAVEL.method_9141(sp);
        } else {
            class_1297 class_12973 = this.entity;
            if (class_12973 instanceof class_3222) {
                class_3222 sp2 = (class_3222)class_12973;
                BECriteria.PORTAL_TRAVEL.method_9141(sp2);
                TravelerState.travelToDimension(sp2, serverLevel, portalInfo);
            } else {
                TravelerState.sendToDimension(this.entity, serverLevel, portalInfo);
            }
            this.entity.method_30229();
        }
    }

    public static class_1297 sendToDimension(class_1297 traveler, class_3218 serverLevel, @NotNull class_5454 portalInfo) {
        class_1937 level = traveler.method_37908();
        if (level instanceof class_3218) {
            class_3218 sourceDimension = (class_3218)level;
            if (!traveler.method_31481()) {
                traveler.method_18375();
                class_1297 copy = traveler.method_5864().method_5883((class_1937)serverLevel);
                if (copy != null) {
                    copy.method_5878(traveler);
                    copy.method_5808(portalInfo.field_25879.field_1352, portalInfo.field_25879.field_1351, portalInfo.field_25879.field_1350, portalInfo.field_25881, copy.method_36455());
                    copy.method_18799(portalInfo.field_25880);
                    serverLevel.method_18769(copy);
                }
                traveler.method_30076();
                sourceDimension.method_14197();
                serverLevel.method_14197();
                return copy;
            }
        }
        return null;
    }

    public static class_1297 travelToDimension(class_3222 traveler, class_3218 serverLevel, @NotNull class_5454 portalInfo) {
        class_5217 levelData = serverLevel.method_8401();
        class_3218 sourceDimension = traveler.method_51469();
        class_3324 playerList = traveler.field_13995.method_3760();
        traveler.field_13985 = true;
        traveler.method_18375();
        traveler.field_13987.method_14364((class_2596)new class_2724(serverLevel.method_44013(), serverLevel.method_27983(), class_4543.method_27984((long)serverLevel.method_8412()), traveler.field_13974.method_14257(), traveler.field_13974.method_30119(), serverLevel.method_27982(), serverLevel.method_28125(), 3, traveler.method_43122(), traveler.method_51848()));
        traveler.field_13987.method_14364((class_2596)new class_2632(levelData.method_207(), levelData.method_197()));
        playerList.method_14576(traveler);
        sourceDimension.method_18770(traveler, class_1297.class_5529.field_27002);
        traveler.method_31482();
        traveler.method_51468(serverLevel);
        traveler.field_13987.method_14372();
        serverLevel.method_18211(traveler);
        traveler.method_18783(sourceDimension);
        traveler.field_13987.method_14363(portalInfo.field_25879.field_1352, portalInfo.field_25879.field_1351, portalInfo.field_25879.field_1350, portalInfo.field_25881, portalInfo.field_25882);
        playerList.method_14606(traveler, serverLevel);
        playerList.method_14594(traveler);
        traveler.field_13987.method_14364((class_2596)new class_2696(traveler.method_31549()));
        TravelerState.sendPlayerEffects(traveler);
        traveler.field_13987.method_14364((class_2596)new class_2673(1032, class_2338.field_10980, 0, false));
        traveler.field_13978 = -1;
        traveler.field_13997 = -1.0f;
        traveler.field_13979 = -1;
        sourceDimension.method_14197();
        serverLevel.method_14197();
        return traveler;
    }

    private static void sendPlayerEffects(class_3222 traveler) {
        for (class_1293 mobEffectInstance : traveler.method_6026()) {
            traveler.field_13987.method_14364((class_2596)new class_2783(traveler.method_5628(), mobEffectInstance));
        }
    }

    @Nullable
    private class_5454 findDimensionEntryPoint(class_3218 targetLevel) {
        boolean toEnd;
        boolean bl = toEnd = targetLevel.method_27983() == class_1937.field_25181;
        if (this.level().method_27983() != class_1937.field_25181 && !toEnd) {
            return null;
        }
        class_2784 worldBorder = targetLevel.method_8621();
        class_2338 startingPos = PortalBuilder.getStartingPos(this.level(), (class_1937)targetLevel, this.entity, worldBorder);
        return this.getExitPortal(targetLevel, startingPos, toEnd, worldBorder).map(foundRectangle -> {
            class_243 vec3;
            class_2350.class_2351 axis;
            class_2680 blockState = this.level().method_8320(this.portalEntrancePos);
            if (blockState.method_28498((class_2769)class_2741.field_12529)) {
                axis = (class_2350.class_2351)blockState.method_11654((class_2769)class_2741.field_12529);
                class_5459.class_5460 foundRectangle2 = class_5459.method_30574((class_2338)this.portalEntrancePos, (class_2350.class_2351)axis, (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, blockPos -> this.level().method_8320(blockPos) == blockState);
                vec3 = this.getRelativePortalPosition(axis, foundRectangle2);
            } else {
                axis = class_2350.class_2351.field_11048;
                vec3 = new class_243(0.5, 0.0, 0.0);
            }
            return class_2424.method_30484((class_3218)targetLevel, (class_5459.class_5460)foundRectangle, (class_2350.class_2351)axis, (class_243)vec3, (class_1297)this.entity, (class_243)this.entity.method_18798(), (float)this.entity.method_36454(), (float)this.entity.method_36455());
        }).orElse(null);
    }

    protected Optional<class_5459.class_5460> getExitPortal(class_3218 targetLevel, class_2338 startingPos, boolean bl, class_2784 worldBorder) {
        PortalBuilder builder = new PortalBuilder(this.level(), targetLevel);
        Optional<class_5459.class_5460> portalRectangle = builder.findPortalAround(startingPos, worldBorder);
        if (portalRectangle.isPresent()) {
            return portalRectangle;
        }
        BetterEnd.LOGGER.error("Unable to locate an active portal");
        return portalRectangle;
    }

    protected class_243 getRelativePortalPosition(class_2350.class_2351 axis, class_5459.class_5460 foundRectangle) {
        return class_2424.method_30494((class_5459.class_5460)foundRectangle, (class_2350.class_2351)axis, (class_243)this.entity.method_19538(), (class_4048)this.entity.method_18377(this.entity.method_18376()));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TravelerState that = (TravelerState)obj;
        return Objects.equals(this.entity, that.entity) && Objects.equals(this.portalEntrancePos, that.portalEntrancePos) && this.isInsidePortal == that.isInsidePortal;
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.portalEntrancePos, this.isInsidePortal);
    }

    public String toString() {
        return "TravelerState[entity=" + this.entity + ", portalEntrancePos=" + this.portalEntrancePos + ", isInsidePortal=" + this.isInsidePortal + "]";
    }
}

