/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.commands;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1936;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3079;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7066;
import net.minecraft.class_7157;
import net.minecraft.class_7924;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.poi.BCLPoiType;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.registry.EndPoiTypes;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.joml.Vector3d;

public class CommandRegistry {
    private static int biomeIndex = 0;
    private static final int MAX_SEARCH_RADIUS = 12800;
    private static final int SAMPLE_RESOLUTION_HORIZONTAL = 32;
    private static final int SAMPLE_RESOLUTION_VERTICAL = 64;
    private static final DynamicCommandExceptionType ERROR_BIOME_NOT_FOUND = new DynamicCommandExceptionType(object -> class_2561.method_43470((String)("The next biome (" + object + ") was not found.")));

    public static void register() {
        CommandRegistrationCallback.EVENT.register(CommandRegistry::register);
    }

    private static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"be").requires(source -> source.method_9259(4))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"locate_portal").requires(source -> source.method_9259(4))).executes(ctx -> CommandRegistry.find_poi((CommandContext<class_2168>)ctx, EndPoiTypes.ETERNAL_PORTAL)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"locate_portal_frame").requires(source -> source.method_9259(4))).executes(ctx -> CommandRegistry.find_poi((CommandContext<class_2168>)ctx, EndPoiTypes.ETERNAL_PORTAL_FRAME)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tpnext").requires(source -> source.method_9259(4))).executes(CommandRegistry::teleportToNextBiome)));
    }

    private static int find_poi(CommandContext<class_2168> ctx, BCLPoiType poi) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 player = source.method_9207();
        class_243 pos = source.method_9222();
        class_3218 level = source.method_9225();
        class_2338.class_2339 mPos = new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350).method_25503();
        System.out.println("Searching POI: " + poi.key);
        Optional found = poi.findPoiAround(level, (class_2338)mPos, false, level.method_8621());
        System.out.println("Found at: " + found.orElse(null));
        if (found.isPresent()) {
            BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)((class_2338)found.get()), (class_2248)class_2246.field_10542);
            BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)mPos, (class_2248)class_2246.field_10242);
        } else {
            BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)mPos, (class_2248)class_2246.field_10058);
        }
        return 1;
    }

    private static int teleportToNextBiome(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2338 target;
        class_2680 state;
        class_2168 source = (class_2168)ctx.getSource();
        List<BCLBiome> biomes = EndBiome.getAllBeBiomes();
        if (biomeIndex < 0 || biomeIndex >= biomes.size()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Failed to find the next Biome...").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
            return 0;
        }
        final BCLBiome biome = biomes.get(biomeIndex);
        source.method_9226(() -> class_2561.method_43470((String)("Locating Biome " + biome)).method_10862(class_2583.field_24360.method_10977(class_124.field_1077)), false);
        biomeIndex = (biomeIndex + 1) % biomes.size();
        class_2338 currentPosition = new class_2338((int)source.method_9222().field_1352, (int)source.method_9222().field_1351, (int)source.method_9222().field_1350);
        class_2338 biomePosition = (class_2338)source.method_9225().method_42108(b -> ((class_5321)b.method_40230().orElseThrow()).method_29177().equals((Object)biome.getID()), currentPosition, 12800, 32, 64).getFirst();
        final String biomeName = biome.toString();
        if (biomePosition == null) {
            throw ERROR_BIOME_NOT_FOUND.create((Object)biomeName);
        }
        class_3222 player = source.method_9207();
        double yPos = source.method_9222().method_10214();
        boolean didWrap = false;
        do {
            target = new class_2338(biomePosition.method_10263(), (int)yPos, biomePosition.method_10260());
            state = player.method_37908().method_8320(target);
            if (!((yPos -= 1.0) <= (double)(player.method_37908().method_31607() + 1))) continue;
            if (didWrap) break;
            yPos = 127.0;
            didWrap = true;
        } while (!state.method_26215() && yPos > (double)player.method_37908().method_31607() && yPos < (double)player.method_37908().method_31600());
        Vector3d targetPlayerPos = new Vector3d((double)target.method_10263() + 0.5, (double)(target.method_10264() - 1), (double)target.method_10260() + 0.5);
        player.field_13987.method_14360(targetPlayerPos.x, targetPlayerPos.y, targetPlayerPos.z, 0.0f, 0.0f, Collections.EMPTY_SET);
        class_7066.class_7068 result = new class_7066.class_7068(){

            public Either<class_5321, class_6862> method_41173() {
                return Either.left((Object)biome.getBiomeKey());
            }

            public Optional<class_7066.class_7068> method_41175(class_5321 resourceKey) {
                return Optional.empty();
            }

            public String method_41176() {
                return biomeName;
            }

            public boolean test(Object o) {
                return false;
            }
        };
        class_5321 a = biome.getBiomeKey();
        if (WorldBootstrap.getLastRegistryAccess() != null) {
            Stopwatch stopwatch = Stopwatch.createStarted((Ticker)class_156.field_37250);
            class_6880 h = (class_6880)WorldBootstrap.getLastRegistryAccess().method_30530(class_7924.field_41236).method_40264(a).orElseThrow();
            stopwatch.stop();
            return class_3079.method_24499((class_2168)source, (class_7066.class_7068)result, (class_2338)currentPosition, (Pair)new Pair((Object)biomePosition, (Object)h), (String)"commands.locatebiome.success", (boolean)false, (Duration)stopwatch.elapsed());
        }
        return 1;
    }
}

