/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="arcaneadditions", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TreeFinder {
    public static Iterable<Holder<Block>> logs;
    public static Iterable<Holder<Block>> leaves;
    private static int maxNumTreeBlocks;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        TagKey leavesTag = BlockTags.create((ResourceLocation)new ResourceLocation("arcaneadditions:leaves"));
        TagKey trunksTag = BlockTags.create((ResourceLocation)new ResourceLocation("arcaneadditions:trunks"));
        leaves = event.getRegistryAccess().m_175515_(Registries.f_256747_).m_206058_(leavesTag);
        logs = event.getRegistryAccess().m_175515_(Registries.f_256747_).m_206058_(trunksTag);
    }

    public static Set<BlockPos> getConnectedBlocks(Collection<BlockPos> startingPoints, Function<BlockPos, Stream<BlockPos>> searchOffsetsSupplier, int maxNumBlocks, AtomicInteger iterationCounter) {
        HashSet<BlockPos> connectedBlocks = new HashSet<BlockPos>();
        List<Object> newConnectedBlocks = new LinkedList<BlockPos>(startingPoints);
        iterationCounter.set(0);
        do {
            connectedBlocks.addAll(newConnectedBlocks);
            if (connectedBlocks.size() >= maxNumBlocks) break;
            newConnectedBlocks = newConnectedBlocks.stream().flatMap(blockPos -> ((Stream)searchOffsetsSupplier.apply((BlockPos)blockPos)).filter(pos1 -> !connectedBlocks.contains(pos1))).limit(maxNumBlocks - connectedBlocks.size()).collect(Collectors.toList());
            iterationCounter.incrementAndGet();
        } while (!newConnectedBlocks.isEmpty());
        return connectedBlocks;
    }

    public static Set<BlockPos> getConnectedBlocks(Collection<BlockPos> startingPoints, Function<BlockPos, Stream<BlockPos>> searchOffsetsSupplier, int maxNumBlocks) {
        return TreeFinder.getConnectedBlocks(startingPoints, searchOffsetsSupplier, maxNumBlocks, new AtomicInteger());
    }

    public static Set<BlockPos> getTreeBlocks(Level level, BlockPos blockPos, Predicate<BlockPos> logCondition, AtomicBoolean inHasLeaves) {
        if (!logCondition.test(blockPos)) {
            return Collections.emptySet();
        }
        AtomicBoolean overrideHasLeaves = new AtomicBoolean(inHasLeaves.get());
        boolean valueToOverrideHasLeaves = inHasLeaves.get();
        AtomicBoolean trueHasLeaves = new AtomicBoolean(false);
        Set<BlockPos> supportedBlocks = TreeFinder.getConnectedBlocks(Collections.singletonList(blockPos), somePos -> BlockNeighbors.HORIZONTAL_AND_ABOVE.asStream((BlockPos)somePos).peek(pos -> trueHasLeaves.compareAndSet(false, TreeFinder.isBlockLeaves(level, pos))).filter(logCondition), maxNumTreeBlocks);
        if (supportedBlocks.size() >= maxNumTreeBlocks) {
            // empty if block
        }
        inHasLeaves.set(overrideHasLeaves.get() ? valueToOverrideHasLeaves : trueHasLeaves.get());
        return supportedBlocks;
    }

    public static Set<BlockPos> getRootBlocks(Level level, BlockPos blockPos, Predicate<BlockPos> logCondition) {
        if (!logCondition.test(blockPos)) {
            return Collections.emptySet();
        }
        Set<BlockPos> supportingBlocks = TreeFinder.getConnectedBlocks(Collections.singletonList(blockPos), somePos -> BlockNeighbors.BELOW.asStream((BlockPos)somePos).filter(logCondition), maxNumTreeBlocks);
        return supportingBlocks;
    }

    public static boolean isBlockALog(BlockState blockState) {
        AtomicBoolean isLog = new AtomicBoolean(false);
        logs.forEach(log -> {
            ResourceLocation loc = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_());
            if (loc != null && log.m_203373_(loc)) {
                isLog.set(true);
            }
        });
        return isLog.get();
    }

    public static boolean isBlockALog(Level level, BlockPos pos) {
        return TreeFinder.isBlockALog(level.m_8055_(pos));
    }

    public static boolean isBlockLeaves(Level level, BlockPos pos) {
        return TreeFinder.isBlockLeaves(level.m_8055_(pos));
    }

    public static boolean isBlockLeaves(BlockState blockState) {
        AtomicBoolean isLeaves = new AtomicBoolean(false);
        leaves.forEach(leaf -> {
            ResourceLocation loc = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_());
            if (loc != null && leaf.m_203373_(loc)) {
                isLeaves.set(true);
            }
        });
        if (isLeaves.get()) {
            return !blockState.m_61138_((Property)LeavesBlock.f_54419_) || (Boolean)blockState.m_61143_((Property)LeavesBlock.f_54419_) == false;
        }
        return false;
    }

    public static boolean isPartOfATree(Level level, BlockPos pos, boolean mustHaveLeaves) {
        AtomicBoolean hasLeaves = new AtomicBoolean(false);
        Set<BlockPos> treeBlocks = TreeFinder.getTreeBlocks(level, pos, blockPos -> TreeFinder.isBlockALog(level, blockPos), hasLeaves);
        if (treeBlocks.isEmpty()) {
            return false;
        }
        if (mustHaveLeaves) {
            return hasLeaves.get();
        }
        return treeBlocks.size() >= (hasLeaves.get() ? 1 : 2);
    }

    static {
        maxNumTreeBlocks = 64;
    }

    public static class BlockNeighbors {
        protected final BlockPos[] blocks;
        public static final BlockNeighbors HORIZONTAL_ADJACENTS = new BlockNeighbors((BlockPos[])Stream.of(new BlockPos(-1, 0, 0), new BlockPos(0, 0, -1), new BlockPos(1, 0, 0), new BlockPos(0, 0, 1)).toArray(BlockPos[]::new));
        public static final BlockNeighbors VERTICAL_ADJACENTS = new BlockNeighbors((BlockPos[])Stream.of(new BlockPos(0, -1, 0), new BlockPos(0, 1, 0)).toArray(BlockPos[]::new));
        public static final BlockNeighbors ADJACENTS = new BlockNeighbors((BlockPos[])Stream.of(HORIZONTAL_ADJACENTS.asStream(), VERTICAL_ADJACENTS.asStream()).flatMap(a -> a).toArray(BlockPos[]::new));
        public static final BlockNeighbors HORIZONTAL_DIAGONALS = new BlockNeighbors((BlockPos[])Stream.of(new BlockPos(-1, 0, -1), new BlockPos(-1, 0, 1), new BlockPos(1, 0, -1), new BlockPos(1, 0, 1)).toArray(BlockPos[]::new));
        public static final BlockNeighbors HORIZONTAL = new BlockNeighbors((BlockPos[])Stream.of(HORIZONTAL_ADJACENTS.asStream(), HORIZONTAL_DIAGONALS.asStream()).flatMap(a -> a).toArray(BlockPos[]::new));
        public static final BlockNeighbors ABOVE_ADJACENTS = new BlockNeighbors((BlockPos[])Stream.of(new BlockPos(-1, 1, 0), new BlockPos(0, 1, -1), new BlockPos(1, 1, 0), new BlockPos(0, 1, 1)).toArray(BlockPos[]::new));
        public static final BlockNeighbors ABOVE_DIAGONALS = new BlockNeighbors((BlockPos[])Stream.of(new BlockPos(-1, 1, -1), new BlockPos(-1, 1, 1), new BlockPos(1, 1, -1), new BlockPos(1, 1, 1)).toArray(BlockPos[]::new));
        public static final BlockNeighbors ABOVE = new BlockNeighbors((BlockPos[])Stream.of(ABOVE_ADJACENTS.asStream(), ABOVE_DIAGONALS.asStream(), Stream.of(new BlockPos(0, 1, 0))).flatMap(a -> a).toArray(BlockPos[]::new));
        public static final BlockNeighbors HORIZONTAL_AND_ABOVE = new BlockNeighbors((BlockPos[])Stream.of(HORIZONTAL.asStream(), ABOVE.asStream()).flatMap(a -> a).toArray(BlockPos[]::new));
        public static final BlockNeighbors BELOW_ADJACENTS = new BlockNeighbors((BlockPos[])Stream.of(new BlockPos(-1, -1, 0), new BlockPos(0, -1, -1), new BlockPos(1, -1, 0), new BlockPos(0, -1, 1)).toArray(BlockPos[]::new));
        public static final BlockNeighbors BELOW_DIAGONALS = new BlockNeighbors((BlockPos[])Stream.of(new BlockPos(-1, -1, -1), new BlockPos(-1, -1, 1), new BlockPos(1, -1, -1), new BlockPos(1, -1, 1)).toArray(BlockPos[]::new));
        public static final BlockNeighbors BELOW = new BlockNeighbors((BlockPos[])Stream.of(BELOW_ADJACENTS.asStream(), BELOW_DIAGONALS.asStream(), Stream.of(new BlockPos(0, -1, 0))).flatMap(a -> a).toArray(BlockPos[]::new));
        public static final BlockNeighbors ADJACENTS_AND_DIAGONALS = new BlockNeighbors((BlockPos[])Stream.of(ABOVE.asStream(), HORIZONTAL.asStream(), BELOW.asStream()).flatMap(a -> a).toArray(BlockPos[]::new));
        public static final BlockNeighbors ADJACENTS_AND_BELOW_ADJACENTS = new BlockNeighbors((BlockPos[])Stream.of(ADJACENTS.asStream(), BELOW_ADJACENTS.asStream()).flatMap(a -> a).toArray(BlockPos[]::new));

        public BlockNeighbors(BlockPos[] blocks) {
            this.blocks = blocks;
        }

        protected Stream<BlockPos> asStream() {
            return Arrays.stream(this.blocks);
        }

        public Stream<BlockPos> asStream(BlockPos pos) {
            return Arrays.stream(this.blocks).map(arg_0 -> ((BlockPos)pos).m_121955_(arg_0));
        }
    }
}

