/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.faction.IFaction;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IDamageComponent;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.config.GeneralConfig;
import com.mna.factions.Factions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;

public class TransfuseComponent
extends SpellEffect
implements IDamageComponent {
    public TransfuseComponent(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[]{new AttributeValuePair(Attribute.DAMAGE, 2.0f, 1.0f, 10.0f, 0.5f, 20.0f), new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 5.0f, 1.0f, 20.0f)});
    }

    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> mods, SpellContext context) {
        LivingEntity livingTarget = null;
        LivingEntity livingSource = null;
        float damage = mods.getValue(Attribute.DAMAGE) * GeneralConfig.getDamageMultiplier();
        float magnitude = mods.getValue(Attribute.MAGNITUDE);
        float healing = damage * (magnitude / 5.0f);
        if (target.isLivingEntity() && target.getLivingEntity() != null) {
            livingTarget = target.getLivingEntity();
        }
        if (source.getCaster() != null) {
            livingSource = source.getCaster();
        }
        if (livingTarget == null || livingSource == null) {
            return ComponentApplicationResult.NOT_PRESENT;
        }
        if (livingSource.m_6047_()) {
            boolean hurt = livingSource.m_6469_(livingTarget.m_269291_().m_269251_(), damage);
            if (!hurt) {
                return ComponentApplicationResult.FAIL;
            }
            livingTarget.m_5634_(healing);
        } else {
            boolean hurt = livingTarget.m_6469_(livingTarget.m_269291_().m_269251_(), damage);
            if (!hurt) {
                return ComponentApplicationResult.FAIL;
            }
            livingSource.m_5634_(healing);
        }
        return ComponentApplicationResult.SUCCESS;
    }

    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.ARCANE;
    }

    public Affinity getAffinity() {
        return Affinity.ARCANE;
    }

    public SpellPartTags getUseTag() {
        return SpellPartTags.HARMFUL;
    }

    public float initialComplexity() {
        return 50.0f;
    }

    public int requiredXPForRote() {
        return 100;
    }

    public IFaction getFactionRequirement() {
        return Factions.UNDEAD;
    }

    public boolean targetsBlocks() {
        return false;
    }
}

