/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.spells.components;

import com.google.common.collect.BiMap;
import com.mna.api.affinity.Affinity;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.sosly.arcaneadditions.compats.magichem.MagiChemCompat;

public class StripComponent
extends SpellEffect {
    public StripComponent(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[0]);
    }

    public ComponentApplicationResult ApplyEffect(SpellSource caster, SpellTarget target, IModifiedSpellPart<SpellEffect> mods, SpellContext context) {
        if (!target.isBlock()) {
            return ComponentApplicationResult.FAIL;
        }
        Level level = context.getLevel();
        BlockPos pos = target.getBlock();
        BlockState state = level.m_8055_(pos);
        if (level.m_46859_(pos) || !level.m_6425_(pos).m_76178_() || state.m_60734_() instanceof EntityBlock) {
            return ComponentApplicationResult.FAIL;
        }
        Optional<BlockState> strippable = Optional.ofNullable(AxeItem.getAxeStrippingState((BlockState)state));
        if (strippable.isPresent()) {
            level.m_7731_(pos, strippable.get(), 11);
            return ComponentApplicationResult.SUCCESS;
        }
        Optional scrapable = WeatheringCopper.m_154899_((BlockState)state);
        if (scrapable.isPresent()) {
            BlockHitResult hitResult = new BlockHitResult(Vec3.m_82512_((Vec3i)pos), target.getBlockFace((SpellEffect)this), pos, false);
            MagiChemCompat.tryGenerateVerdigris(level, pos, state, hitResult);
            level.m_7731_(pos, (BlockState)scrapable.get(), 11);
            return ComponentApplicationResult.SUCCESS;
        }
        Optional<BlockState> waxed = Optional.ofNullable((Block)((BiMap)HoneycombItem.f_150864_.get()).get((Object)state.m_60734_())).map(waxable -> waxable.m_152465_(state));
        if (waxed.isPresent()) {
            level.m_7731_(pos, waxed.get(), 11);
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    public Affinity getAffinity() {
        return Affinity.WIND;
    }

    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }

    public float initialComplexity() {
        return 5.0f;
    }

    public int requiredXPForRote() {
        return 100;
    }

    public SoundEvent SoundEffect() {
        return SFX.Spell.Cast.WIND;
    }
}

