/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellReagent;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.factions.Factions;
import com.mna.items.sorcery.PhylacteryStaff;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.sosly.arcaneadditions.api.spells.components.IPolymorphProvider;
import org.sosly.arcaneadditions.capabilities.polymorph.IPolymorphCapability;
import org.sosly.arcaneadditions.capabilities.polymorph.PolymorphProvider;
import org.sosly.arcaneadditions.compats.CompatRegistry;
import org.sosly.arcaneadditions.config.ServerConfig;
import org.sosly.arcaneadditions.effects.EffectRegistry;
import org.sosly.arcaneadditions.networking.PacketHandler;
import org.sosly.arcaneadditions.networking.messages.clientbound.SyncPolymorphCapabilitiesToClient;

public class PolymorphComponent
extends SpellEffect {
    private static final ResourceLocation reagent = new ResourceLocation("mna:animus_dust");

    public PolymorphComponent(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[]{new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 4.0f, 1.0f, 1.0f)});
    }

    public ComponentApplicationResult ApplyEffect(SpellSource caster, SpellTarget target, IModifiedSpellPart<SpellEffect> iModifiedSpellPart, SpellContext spellContext) {
        if (!caster.isPlayerCaster() || target.getLivingEntity() == null || !(target.getEntity() instanceof Player)) {
            return ComponentApplicationResult.FAIL;
        }
        IPolymorphProvider polymorpher = CompatRegistry.getPolymorphCompat();
        if (polymorpher == null) {
            return ComponentApplicationResult.FAIL;
        }
        LivingEntity targetEntity = target.getLivingEntity();
        if (targetEntity.m_21023_((MobEffect)EffectRegistry.POLYMORPH.get())) {
            targetEntity.getCapability(PolymorphProvider.POLYMORPH).ifPresent(polymorph -> polymorph.setMorphing(true));
            targetEntity.m_21195_((MobEffect)EffectRegistry.POLYMORPH.get());
            return ComponentApplicationResult.SUCCESS;
        }
        Level level = targetEntity.m_9236_();
        if (!level.m_5776_()) {
            ItemStack phylactery = caster.getHand() == InteractionHand.MAIN_HAND ? targetEntity.m_21206_() : targetEntity.m_21205_();
            ServerPlayer casterPlayer = (ServerPlayer)Objects.requireNonNull(caster.getCaster());
            if (!PhylacteryStaff.isFilled((ItemStack)phylactery)) {
                casterPlayer.m_213846_((Component)Component.m_237115_((String)"arcaneadditions:components/polymorph.nonphylactery"));
                return ComponentApplicationResult.NOT_PRESENT;
            }
            EntityType type = PhylacteryStaff.getEntityType((ItemStack)phylactery);
            if (type == null) {
                casterPlayer.m_213846_((Component)Component.m_237115_((String)"arcaneadditions:components/polymorph.nonphylactery"));
                return ComponentApplicationResult.NOT_PRESENT;
            }
            if (!this.isFormAllowed((EntityType<? extends Mob>)type, iModifiedSpellPart)) {
                casterPlayer.m_213846_((Component)Component.m_237115_((String)"arcaneadditions:components/polymorph.notallowed"));
                return ComponentApplicationResult.FAIL;
            }
            targetEntity.getCapability(PolymorphProvider.POLYMORPH).ifPresent(polymorph -> {
                polymorph.setMorphing(true);
                polymorph.setCaster(caster.getPlayer());
                polymorph.setComplexity(spellContext.getSpell().getComplexity());
                polymorph.setHealth(targetEntity.m_21223_());
                PacketHandler.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)targetEntity), (Object)new SyncPolymorphCapabilitiesToClient((IPolymorphCapability)polymorph));
            });
            polymorpher.polymorph(casterPlayer, (LivingEntity)type.m_20615_(level));
            PolymorphComponent.removeBonusHealth(casterPlayer);
            MobEffectInstance instance = new MobEffectInstance((MobEffect)EffectRegistry.POLYMORPH.get(), Integer.MAX_VALUE);
            targetEntity.m_7292_(instance);
            targetEntity.m_21153_(targetEntity.m_21233_());
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    private boolean isFormAllowed(EntityType<? extends Mob> type, IModifiedSpellPart<SpellEffect> iModifiedSpellPart) {
        AtomicBoolean allowed = new AtomicBoolean(false);
        AtomicInteger tier = new AtomicInteger();
        AtomicReference<Float> magnitude = new AtomicReference<Float>(Float.valueOf(iModifiedSpellPart.getValue(Attribute.MAGNITUDE)));
        String resourceLocation = ((ResourceKey)ForgeRegistries.ENTITY_TYPES.getResourceKey(type).get()).m_135782_().toString();
        ServerConfig.polymorphTiers.forEach(tierList -> {
            tier.getAndIncrement();
            if (tierList.contains(resourceLocation) && ((Float)magnitude.get()).floatValue() >= (float)tier.get()) {
                allowed.set(true);
            }
        });
        return allowed.get();
    }

    public boolean canBeChanneled() {
        return false;
    }

    public Affinity getAffinity() {
        return Affinity.WATER;
    }

    public float initialComplexity() {
        return 1.0f;
    }

    public int requiredXPForRote() {
        return 500;
    }

    public SoundEvent SoundEffect() {
        return SFX.Spell.Cast.WATER;
    }

    public List<SpellReagent> getRequiredReagents(@Nullable Player caster, @Nullable InteractionHand hand) {
        Item animusDust = (Item)ForgeRegistries.ITEMS.getValue(reagent);
        if (animusDust == null) {
            return null;
        }
        List<SpellReagent> reagents = List.of(new SpellReagent((SpellEffect)this, new ItemStack((ItemLike)animusDust), false, false, true));
        if (caster == null) {
            return reagents;
        }
        boolean isMorphed = caster.m_21023_((MobEffect)EffectRegistry.POLYMORPH.get());
        MutableBoolean isFey = new MutableBoolean(false);
        caster.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> isFey.setValue(p.getAlliedFaction() == Factions.FEY));
        MutableBoolean isMorphing = new MutableBoolean(false);
        caster.getCapability(PolymorphProvider.POLYMORPH).ifPresent(p -> isMorphing.setValue(p.isMorphing()));
        if (isFey.booleanValue()) {
            return null;
        }
        if (!isMorphed && !isMorphing.getValue().booleanValue()) {
            return reagents;
        }
        if (isMorphed && isMorphing.getValue().booleanValue()) {
            caster.getCapability(PolymorphProvider.POLYMORPH).ifPresent(p -> p.setMorphing(false));
            return reagents;
        }
        if (!isMorphed && isMorphing.getValue().booleanValue()) {
            caster.getCapability(PolymorphProvider.POLYMORPH).ifPresent(p -> p.setMorphing(false));
            return null;
        }
        if (isMorphed && !isMorphing.getValue().booleanValue()) {
            return null;
        }
        return reagents;
    }

    public static void resetBonusHealth(ServerPlayer target) {
        AttributeInstance inst = target.m_21051_(Attributes.f_22276_);
        if (inst == null) {
            return;
        }
        AtomicInteger tier = new AtomicInteger();
        target.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(progression -> tier.set(progression.getTier()));
        if (tier.get() == 0) {
            return;
        }
        PolymorphComponent.removeBonusHealth(target);
        for (int roteTier = 1; roteTier <= 5; ++roteTier) {
            int index = roteTier - 1;
            int boost = (Integer)GeneralConfigValues.TierHealthBoosts.get(index);
            int modifierAmount = boost >= index ? boost : 0;
            AttributeModifier modifier = new AttributeModifier(UUID.fromString(IPlayerProgression.Tier_Health_Boost_IDs[index]), "Tier Health Boost " + roteTier, (double)modifierAmount, AttributeModifier.Operation.ADDITION);
            if (modifierAmount <= 0 || tier.get() < roteTier || inst.m_22109_(modifier)) continue;
            inst.m_22125_(modifier);
        }
    }

    public static void removeBonusHealth(ServerPlayer target) {
        AttributeInstance inst = target.m_21051_(Attributes.f_22276_);
        if (inst == null) {
            return;
        }
        for (int roteTier = 1; roteTier <= 5; ++roteTier) {
            int index = roteTier - 1;
            int boost = (Integer)GeneralConfigValues.TierHealthBoosts.get(index);
            int modifierAmount = boost >= index ? boost : 0;
            AttributeModifier modifier = new AttributeModifier(UUID.fromString(IPlayerProgression.Tier_Health_Boost_IDs[index]), "Tier Health Boost " + roteTier, (double)modifierAmount, AttributeModifier.Operation.ADDITION);
            if (!inst.m_22109_(modifier)) continue;
            inst.m_22120_(modifier.m_22209_());
        }
    }
}

