/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.sosly.arcaneadditions.compats.Grass_Slabs.DummyPathableBlockProxy;
import org.sosly.arcaneadditions.compats.Grass_Slabs.IPathableBlockProxy;

public class PathComponent
extends SpellEffect {
    public static IPathableBlockProxy proxy = new DummyPathableBlockProxy();
    private static final ResourceLocation PILGRIM = new ResourceLocation("mna", "pilgrim");

    public PathComponent(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[]{new AttributeValuePair(Attribute.DURATION, 30.0f, 30.0f, 600.0f, 30.0f, 10.0f)});
    }

    public ComponentApplicationResult ApplyEffect(SpellSource caster, SpellTarget target, IModifiedSpellPart<SpellEffect> mods, SpellContext context) {
        if (target.isBlock()) {
            BlockState state1;
            Level level = context.getLevel();
            BlockPos pos = target.getBlock();
            BlockState state = level.m_8055_(target.getBlock());
            if (!context.getLevel().m_46859_(target.getBlock()) && context.getLevel().m_6425_(target.getBlock()).m_76178_() && !(state.m_60734_() instanceof EntityBlock) && (state1 = proxy.getPathingState(level, pos, state)) != null && level.m_46859_(pos.m_7494_()) && !level.f_46443_) {
                proxy.setBlock(level, pos, state1);
            }
        }
        LivingEntity targetEntity = target.getLivingEntity();
        LivingEntity casterEntity = caster.getCaster();
        MobEffect pilgrim = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(PILGRIM);
        if (targetEntity != null && targetEntity.equals((Object)casterEntity) && pilgrim != null) {
            casterEntity.m_7292_(new MobEffectInstance(pilgrim, (int)mods.getValue(Attribute.DURATION) * 20, 0, false, false));
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    public Affinity getAffinity() {
        return Affinity.EARTH;
    }

    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }

    public float initialComplexity() {
        return 5.0f;
    }

    public int requiredXPForRote() {
        return 100;
    }

    public static void setProxy(IPathableBlockProxy proxy) {
        PathComponent.proxy = proxy;
    }

    public SoundEvent SoundEffect() {
        return SFX.Spell.Cast.EARTH;
    }
}

