/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.spells.components.PotionEffectComponent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.sosly.arcaneadditions.effects.EffectRegistry;

public class LifeLinkComponent
extends PotionEffectComponent {
    public static final String LINKED = "linked";

    public LifeLinkComponent(ResourceLocation guiIcon) {
        super(guiIcon, EffectRegistry.LIFE_LINK, new AttributeValuePair[]{new AttributeValuePair(Attribute.DURATION, 15.0f, 5.0f, 60.0f, 5.0f, 5.0f)});
    }

    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> mods, SpellContext context) {
        LivingEntity caster = source.getCaster();
        LivingEntity targetEntity = target.getLivingEntity();
        if (caster == null || targetEntity == null || caster.equals((Object)targetEntity)) {
            return ComponentApplicationResult.NOT_PRESENT;
        }
        if (caster.m_21023_((MobEffect)EffectRegistry.LIFE_LINK.get()) || targetEntity.m_21023_((MobEffect)EffectRegistry.LIFE_LINK.get())) {
            return ComponentApplicationResult.FAIL;
        }
        caster.getPersistentData().m_128405_(LINKED, targetEntity.m_19879_());
        targetEntity.getPersistentData().m_128405_(LINKED, caster.m_19879_());
        ComponentApplicationResult result = super.ApplyEffect(source, target, mods, context);
        MobEffectInstance instance = new MobEffectInstance((MobEffect)EffectRegistry.LIFE_LINK.get(), (int)mods.getValue(Attribute.DURATION) * 20);
        caster.m_7292_(instance);
        return result;
    }

    public SoundEvent SoundEffect() {
        return SFX.Spell.Buff.ARCANE;
    }

    protected boolean applicationPredicate(LivingEntity target) {
        return target.m_6072_();
    }

    public Affinity getAffinity() {
        return Affinity.ARCANE;
    }

    public SpellPartTags getUseTag() {
        return SpellPartTags.FRIENDLY;
    }

    public float initialComplexity() {
        return 20.0f;
    }

    public int requiredXPForRote() {
        return 100;
    }

    public void SpawnParticles(Level world, Vec3 impact_position, int age, Player caster, ISpellDefinition recipe) {
        if (age <= 10) {
            float particle_spread = 1.0f;
            float v = 0.4f;
            int particleCount = 10;
            for (int i = 0; i < particleCount; ++i) {
                Vec3 velocity = new Vec3(0.0, -Math.random() * (double)v, 0.0);
                world.m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType)ParticleInit.LIGHT_VELOCITY.get()), (Entity)caster), impact_position.f_82479_ + (double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0, impact_position.f_82480_ + (double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0, impact_position.f_82481_ + (double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
            }
        }
    }

    public boolean targetsBlocks() {
        return false;
    }
}

