/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.spells.components.PotionEffectComponent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.sosly.arcaneadditions.effects.EffectRegistry;

public class EnrageComponent
extends PotionEffectComponent {
    public static final String CASTER = "caster";

    public EnrageComponent(ResourceLocation guiIcon) {
        super(guiIcon, EffectRegistry.ENRAGED, new AttributeValuePair[]{new AttributeValuePair(Attribute.DURATION, 5.0f, 5.0f, 60.0f, 5.0f, 5.0f)});
    }

    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> mods, SpellContext context) {
        LivingEntity targetEntity;
        ComponentApplicationResult result = super.ApplyEffect(source, target, mods, context);
        if (result.is_success && target.isLivingEntity() && source.hasCasterReference() && (targetEntity = target.getLivingEntity()) != null && source.getCaster() != null) {
            targetEntity.getPersistentData().m_128405_(CASTER, source.getCaster().m_19879_());
        }
        return result;
    }

    public SoundEvent SoundEffect() {
        return SFX.Spell.Buff.ENDER;
    }

    public Affinity getAffinity() {
        return Affinity.ENDER;
    }

    public SpellPartTags getUseTag() {
        return SpellPartTags.HARMFUL;
    }

    public float initialComplexity() {
        return 10.0f;
    }

    public int requiredXPForRote() {
        return 100;
    }

    public void SpawnParticles(Level world, Vec3 impact_position, int age, Player caster, ISpellDefinition recipe) {
        if (age <= 10) {
            float particle_spread = 1.0f;
            float v = 0.4f;
            int particleCount = 10;
            for (int i = 0; i < particleCount; ++i) {
                Vec3 velocity = new Vec3(0.0, -Math.random() * (double)v, 0.0);
                world.m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType)ParticleInit.FLAME.get()), (Entity)caster), impact_position.f_82479_ + (double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0, impact_position.f_82480_ + (double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0, impact_position.f_82481_ + (double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
            }
        }
    }

    public boolean targetsBlocks() {
        return false;
    }
}

