/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.effects.EffectInit;
import com.mna.factions.Factions;
import com.mna.network.ServerMessageDispatcher;
import com.mna.spells.components.PotionEffectComponent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.sosly.arcaneadditions.effects.EffectRegistry;
import org.sosly.arcaneadditions.entities.sorcery.AstralProjectionEntity;

public class AstralProjectionComponent
extends PotionEffectComponent {
    public AstralProjectionComponent(ResourceLocation guiIcon) {
        super(guiIcon, EffectRegistry.ASTRAL_PROJECTION, new AttributeValuePair[]{new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 3.0f, 1.0f, 20.0f), new AttributeValuePair(Attribute.DURATION, 15.0f, 15.0f, 120.0f, 15.0f, 10.0f), new AttributeValuePair(Attribute.SPEED, 0.3f, 0.3f, 1.0f, 0.1f, 1.0f)});
    }

    public ComponentApplicationResult ApplyEffect(SpellSource caster, SpellTarget target, IModifiedSpellPart<SpellEffect> mods, SpellContext context) {
        Entity entity;
        if (target.getLivingEntity() == null || !((entity = target.getEntity()) instanceof Player)) {
            return ComponentApplicationResult.FAIL;
        }
        Player controller = (Player)entity;
        assert (context.getServerLevel() != null);
        if (context.getServerLevel().m_5776_() || !caster.isPlayerCaster()) {
            return ComponentApplicationResult.FAIL;
        }
        if (controller.m_21124_((MobEffect)EffectInit.MIND_VISION.get()) != null) {
            return ComponentApplicationResult.FAIL;
        }
        int duration = (int)(mods.getValue(Attribute.DURATION) * 20.0f);
        Level level = context.getLevel();
        AstralProjectionEntity projection = new AstralProjectionEntity(controller, level);
        projection.m_20124_(Pose.STANDING);
        projection.m_20359_((Entity)controller);
        projection.m_20049_("arcaneadditions:astral_projection");
        projection.getPersistentData().m_128362_("astral_controller_id", controller.m_20148_());
        projection.getPersistentData().m_128405_("astral_duration", duration);
        projection.getPersistentData().m_128350_("astral_magnitude", mods.getValue(Attribute.MAGNITUDE));
        controller.getPersistentData().m_128405_("astral_entity_id", projection.m_19879_());
        projection.m_7910_(mods.getValue(Attribute.SPEED));
        if (mods.getValue(Attribute.MAGNITUDE) > 1.0f) {
            projection.m_6853_(false);
            projection.m_20242_(true);
        }
        projection.m_20331_(true);
        if (mods.getValue(Attribute.MAGNITUDE) > 2.0f) {
            projection.f_19794_ = true;
        }
        level.m_7967_((Entity)projection);
        target.overrideSpellTarget((Entity)projection);
        controller.m_7292_(new MobEffectInstance((MobEffect)EffectInit.POSSESSION.get(), duration, 1));
        projection.m_7292_(new MobEffectInstance((MobEffect)EffectInit.POSSESSION.get(), duration));
        controller.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.ASTRAL_PROJECTION.get(), duration));
        projection.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.ASTRAL_PROJECTION.get(), duration));
        ServerMessageDispatcher.sendPlayerPosessionMessage((ServerPlayer)((ServerPlayer)controller), (Entity)projection);
        controller.getPersistentData().m_128405_("posessed_entity_id", projection.m_19879_());
        return ComponentApplicationResult.DELAYED;
    }

    public boolean canBeChanneled() {
        return false;
    }

    public SoundEvent SoundEffect() {
        return SFX.Spell.Cast.BRIAN;
    }

    public Affinity getAffinity() {
        return Affinity.ARCANE;
    }

    public IFaction getFactionRequirement() {
        return Factions.COUNCIL;
    }

    public float initialComplexity() {
        return 50.0f;
    }

    public int requiredXPForRote() {
        return 300;
    }

    public void SpawnParticles(Level world, Vec3 impact_position, Vec3 normal, int age, LivingEntity caster, ISpellDefinition recipe) {
        if (age <= 10) {
            float particle_spread = 1.0f;
            float v = 0.4f;
            int particleCount = 10;
            for (int i = 0; i < particleCount; ++i) {
                Vec3 velocity = new Vec3(0.0, Math.random() * (double)v, 0.0);
                world.m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType)ParticleInit.ARCANE_RANDOM.get()).setScale(0.2f).setColor(10, 10, 10), (Entity)caster), impact_position.f_82479_ + (double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0, impact_position.f_82480_ + (double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0, impact_position.f_82481_ + (double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
            }
        }
    }

    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }
}

