/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.rituals.effects;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.rituals.IRitualContext;
import com.mna.api.rituals.RitualEffect;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.items.ItemInit;
import com.mna.items.sorcery.ItemSpell;
import com.mna.spells.crafting.SpellRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.sosly.arcaneadditions.capabilities.familiar.IFamiliarCapability;
import org.sosly.arcaneadditions.spells.FamiliarSpell;
import org.sosly.arcaneadditions.utils.FamiliarHelper;

public class TrainFamiliarRitual
extends RitualEffect {
    public TrainFamiliarRitual(ResourceLocation name) {
        super(name);
    }

    public boolean applyStartCheckInCreative() {
        return true;
    }

    public Component canRitualStart(IRitualContext context) {
        if (context.getCaster() == null) {
            return Component.m_237113_((String)"No player reference found for ritual, aborting.");
        }
        IPlayerProgression p = (IPlayerProgression)context.getCaster().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (p == null || p.getTier() < 3) {
            return Component.m_237113_((String)"You must be at least tier 3 to train a familiar.");
        }
        IFamiliarCapability f = FamiliarHelper.getFamiliarCapability(context.getCaster());
        if (f == null || f.getType() == null) {
            return Component.m_237113_((String)"You must have a familiar to train.");
        }
        return null;
    }

    protected boolean applyRitualEffect(IRitualContext context) {
        Player player = context.getCaster();
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return false;
        }
        IFamiliarCapability familiar = FamiliarHelper.getFamiliarCapability(player);
        if (familiar == null) {
            return false;
        }
        ItemStack ingotItem = (ItemStack)context.getCollectedReagents().get(1);
        FamiliarSpell.Frequency frequency = FamiliarSpell.Frequency.ByIngot(ingotItem);
        if (frequency == null) {
            return false;
        }
        ItemStack reagent = (ItemStack)context.getCollectedReagents().get(3);
        boolean offensive = Items.f_42403_.equals(reagent.m_41720_());
        ItemStack recipeItem = (ItemStack)context.getCollectedReagents().get(6);
        if (!((ItemSpell)ItemInit.SPELL.get()).equals(recipeItem.m_41720_())) {
            return false;
        }
        SpellRecipe recipe = SpellRecipe.fromNBT((CompoundTag)recipeItem.m_41784_());
        if (recipe == null) {
            return false;
        }
        Component name = recipeItem.m_41611_();
        FamiliarSpell spell = new FamiliarSpell(name, recipe, frequency, offensive);
        familiar.addSpellKnown(spell, true);
        return true;
    }

    protected int getApplicationTicks(IRitualContext iRitualContext) {
        return 20;
    }
}

