/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.rituals.effects;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.rituals.IRitualContext;
import com.mna.api.rituals.RitualEffect;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.items.sorcery.EntityCrystal;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.sosly.arcaneadditions.capabilities.familiar.IFamiliarCapability;
import org.sosly.arcaneadditions.config.ServerConfig;
import org.sosly.arcaneadditions.utils.FamiliarHelper;

public class BindFamiliarRitual
extends RitualEffect {
    public BindFamiliarRitual(ResourceLocation name) {
        super(name);
    }

    public Component canRitualStart(IRitualContext context) {
        if (context.getCaster() == null) {
            return Component.m_237113_((String)"No player reference found for ritual, aborting.");
        }
        IPlayerProgression p = (IPlayerProgression)context.getCaster().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        return p != null && p.getTier() >= 3 ? null : Component.m_237113_((String)"You must be at least tier 3 to bind a familiar.");
    }

    protected boolean applyRitualEffect(IRitualContext context) {
        Entity restoredEntity;
        ItemStack stack = ItemStack.f_41583_;
        Iterator reagents = context.getCollectedReagents().iterator();
        Player player = context.getCaster();
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return false;
        }
        ResourceKey dimension = player.m_9236_().m_46472_();
        ServerLevel level = server.m_129880_(dimension);
        if (level == null) {
            return false;
        }
        BlockPos pos = context.getCenter();
        while (reagents.hasNext()) {
            ItemStack itemStack = (ItemStack)reagents.next();
            if (!(itemStack.m_41720_() instanceof EntityCrystal)) continue;
            stack = itemStack;
            break;
        }
        if (stack.m_41619_()) {
            player.m_213846_((Component)Component.m_237115_((String)"arcaneadditions:rituals/bind_familiar.no_crystal"));
            return false;
        }
        EntityType type = EntityCrystal.getEntityType((ItemStack)stack);
        if (type == null) {
            player.m_213846_((Component)Component.m_237115_((String)"arcaneadditions:rituals/bind_familiar.no_crystal"));
            return false;
        }
        if (!ServerConfig.familiars.contains(EntityType.m_20613_((EntityType)type).toString())) {
            player.m_213846_((Component)Component.m_237115_((String)"arcaneadditions:rituals/bind_familiar.invalid_familiar"));
            return false;
        }
        if (FamiliarHelper.hasFamiliar(player)) {
            FamiliarHelper.removeFamiliar(player);
        }
        if (!((restoredEntity = EntityCrystal.restoreEntity((Level)level, (ItemStack)stack)) instanceof Mob)) {
            player.m_213846_((Component)Component.m_237115_((String)"arcaneadditions:rituals/bind_familiar.invalid_familiar"));
            return false;
        }
        Mob restoredMob = (Mob)restoredEntity;
        IFamiliarCapability cap = FamiliarHelper.getFamiliarCapability(player);
        if (cap == null) {
            player.m_213846_((Component)Component.m_237115_((String)"arcaneadditions:rituals/bind_familiar.failed"));
            return false;
        }
        CompoundTag nbt = new CompoundTag();
        restoredMob.m_20240_(nbt);
        cap.setFamiliarNBT(nbt);
        restoredMob.m_146870_();
        String name = player.m_5446_().getString();
        MutableComponent familiarName = Component.m_237113_((String)name).m_130946_("'s ").m_7220_((Component)Component.m_237115_((String)type.m_20675_())).m_130946_(" Familiar");
        if (!FamiliarHelper.createFamiliar(player, (EntityType<? extends Mob>)type, (Component)familiarName, (Level)level, pos)) {
            player.m_213846_((Component)Component.m_237115_((String)"arcaneadditions:rituals/bind_familiar.failed"));
            return false;
        }
        cap.getCastingResource().setAmount(0.0f);
        player.m_213846_((Component)Component.m_237110_((String)"arcaneadditions:rituals/bind_familiar.success", (Object[])new Object[]{name}));
        return true;
    }

    protected int getApplicationTicks(IRitualContext context) {
        return 20;
    }
}

