/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.sosly.arcaneadditions.recipes.PlowTransformationRecipe;

public class PlowTransformationSerializer
implements RecipeSerializer<PlowTransformationRecipe> {
    public PlowTransformationRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        String inputId = GsonHelper.m_13906_((JsonObject)json, (String)"input");
        Block input = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(inputId));
        if (input == null) {
            throw new IllegalArgumentException("Unknown block: " + inputId);
        }
        String outputId = GsonHelper.m_13906_((JsonObject)json, (String)"output");
        Block outputBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(outputId));
        if (outputBlock == null) {
            throw new IllegalArgumentException("Unknown block: " + outputId);
        }
        BlockState output = outputBlock.m_49966_();
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (json.has("drops")) {
            for (JsonElement element : GsonHelper.m_13933_((JsonObject)json, (String)"drops")) {
                JsonObject dropJson = element.getAsJsonObject();
                String itemId = GsonHelper.m_13906_((JsonObject)dropJson, (String)"item");
                int count = GsonHelper.m_13824_((JsonObject)dropJson, (String)"count", (int)1);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
                if (item == null) {
                    throw new IllegalArgumentException("Unknown item: " + itemId);
                }
                drops.add(new ItemStack((ItemLike)item, count));
            }
        }
        boolean needsAir = GsonHelper.m_13855_((JsonObject)json, (String)"needs_air", (boolean)true);
        return new PlowTransformationRecipe(recipeId, input, output, drops, needsAir);
    }

    public PlowTransformationRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        ResourceLocation inputId = buffer.m_130281_();
        Block input = (Block)ForgeRegistries.BLOCKS.getValue(inputId);
        ResourceLocation outputId = buffer.m_130281_();
        Block outputBlock = (Block)ForgeRegistries.BLOCKS.getValue(outputId);
        BlockState output = outputBlock != null ? outputBlock.m_49966_() : null;
        int dropCount = buffer.m_130242_();
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = 0; i < dropCount; ++i) {
            drops.add(buffer.m_130267_());
        }
        boolean needsAir = buffer.readBoolean();
        return new PlowTransformationRecipe(recipeId, input, output, drops, needsAir);
    }

    public void toNetwork(FriendlyByteBuf buffer, PlowTransformationRecipe recipe) {
        buffer.m_130085_(ForgeRegistries.BLOCKS.getKey((Object)recipe.input));
        buffer.m_130085_(ForgeRegistries.BLOCKS.getKey((Object)recipe.output.m_60734_()));
        buffer.m_130130_(recipe.drops.size());
        for (ItemStack drop : recipe.drops) {
            buffer.m_130055_(drop);
        }
        buffer.writeBoolean(recipe.needsAir);
    }
}

