/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.networking.messages.serverbound;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.sosly.arcaneadditions.capabilities.familiar.IFamiliarCapability;
import org.sosly.arcaneadditions.networking.BaseMessage;
import org.sosly.arcaneadditions.networking.PacketHandler;
import org.sosly.arcaneadditions.networking.messages.ServerMessageHandler;
import org.sosly.arcaneadditions.networking.messages.clientbound.UpdateFamiliarData;
import org.sosly.arcaneadditions.utils.FamiliarHelper;

public class RequestFamiliarDataUpdate
extends BaseMessage {
    public static RequestFamiliarDataUpdate decode(FriendlyByteBuf buf) {
        RequestFamiliarDataUpdate msg = new RequestFamiliarDataUpdate();
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(RequestFamiliarDataUpdate msg, FriendlyByteBuf buf) {
    }

    public static void handleRequestFamiliarDataUpdate(RequestFamiliarDataUpdate msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        if (!ServerMessageHandler.validateBasics(msg, ctx)) {
            return;
        }
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        IFamiliarCapability cap = FamiliarHelper.getFamiliarCapability((Player)player);
        if (cap == null || cap.getFamiliar() == null) {
            return;
        }
        UpdateFamiliarData updatePacket = new UpdateFamiliarData(cap.getFamiliar().m_21223_(), cap.getFamiliar().m_21233_(), cap.getCastingResource().getAmount(), cap.getCastingResource().getMaxAmount());
        PacketHandler.network.send(PacketDistributor.PLAYER.with(() -> player), (Object)updatePacket);
    }
}

