/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.networking.messages.serverbound;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.sosly.arcaneadditions.ArcaneAdditions;
import org.sosly.arcaneadditions.capabilities.treestride.TreestrideProvider;
import org.sosly.arcaneadditions.networking.BaseMessage;
import org.sosly.arcaneadditions.networking.messages.ServerMessageHandler;

public class RemoveTreeStrideDestination
extends BaseMessage {
    private final BlockPos pos;

    public RemoveTreeStrideDestination(BlockPos pos) {
        this.pos = pos;
    }

    public static RemoveTreeStrideDestination decode(FriendlyByteBuf buf) {
        RemoveTreeStrideDestination msg;
        try {
            BlockPos pos = buf.m_130135_();
            msg = new RemoveTreeStrideDestination(pos);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException err) {
            ArcaneAdditions.LOGGER.error("Exception while reading SendNewTreeStrideDestinationToServer: {}", (Object)err.toString());
            return null;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(RemoveTreeStrideDestination msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
    }

    public static void handleRemoveTreeStrideDestination(RemoveTreeStrideDestination msg, Supplier<NetworkEvent.Context> contextSupplier) {
        ServerPlayer player;
        NetworkEvent.Context ctx = contextSupplier.get();
        if (ServerMessageHandler.validateBasics(msg, ctx) && (player = ctx.getSender()) != null) {
            Level level = player.m_9236_();
            ctx.enqueueWork(() -> level.getCapability(TreestrideProvider.TREESTRIDE).ifPresent(treestride -> {
                treestride.removeDestination(player, msg.pos);
                treestride.clearCurrentPosition(player);
            }));
        }
    }
}

