/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.networking.messages.serverbound;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.sosly.arcaneadditions.capabilities.familiar.IFamiliarCapability;
import org.sosly.arcaneadditions.networking.BaseMessage;
import org.sosly.arcaneadditions.networking.messages.ServerMessageHandler;
import org.sosly.arcaneadditions.spells.FamiliarSpell;
import org.sosly.arcaneadditions.utils.FamiliarHelper;

public class RemoveFamiliarSpell
extends BaseMessage {
    private final String spellName;

    public RemoveFamiliarSpell(String spellName) {
        this.spellName = spellName;
    }

    public static RemoveFamiliarSpell decode(FriendlyByteBuf buf) {
        RemoveFamiliarSpell msg;
        try {
            String spellName = buf.m_130277_();
            msg = new RemoveFamiliarSpell(spellName);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException err) {
            return null;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(RemoveFamiliarSpell msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.spellName);
    }

    public static void handleRemoveFamiliarSpell(RemoveFamiliarSpell msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        if (!ServerMessageHandler.validateBasics(msg, ctx)) {
            return;
        }
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        IFamiliarCapability cap = FamiliarHelper.getFamiliarCapability((Player)player);
        if (cap == null || cap.getFamiliar() == null) {
            return;
        }
        if (!cap.getCaster().equals((Object)player)) {
            return;
        }
        FamiliarSpell toRemove = cap.getSpellsKnown().stream().filter(spell -> spell.getName().getString().equals(msg.spellName)).findFirst().orElse(null);
        if (toRemove != null) {
            cap.getSpellsKnown().remove(toRemove);
        }
    }
}

