/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.gui.screens;

import com.mna.items.ItemInit;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.sosly.arcaneadditions.gui.menus.FamiliarMenu;
import org.sosly.arcaneadditions.gui.widgets.SpellRemoveButton;
import org.sosly.arcaneadditions.networking.PacketHandler;
import org.sosly.arcaneadditions.networking.messages.serverbound.RemoveFamiliarSpell;
import org.sosly.arcaneadditions.networking.messages.serverbound.RequestFamiliarDataUpdate;
import org.sosly.arcaneadditions.spells.FamiliarSpell;
import org.sosly.arcaneadditions.utils.RLoc;

public class FamiliarScreen
extends AbstractContainerScreen<FamiliarMenu> {
    private static final ResourceLocation TEXTURE = RLoc.create("textures/gui/familiar.png");
    private static final int INFO_LABEL_X = 60;
    private static final int INFO_VALUE_X = 100;
    private static final int OWNER_Y = 17;
    private static final int TYPE_Y = 27;
    private static final int HEALTH_Y = 37;
    private static final int MANA_Y = 47;
    private static final int SPELLS_LABEL_Y = 57;
    private static final int SPELLS_START_Y = 67;
    private static final int SPELL_LINE_HEIGHT = 10;
    private static final int SPELL_ICON_X = 60;
    private static final int SPELL_TEXT_X = 70;
    private static final int SPELL_INGOT_X = 165;
    private static final int SPELL_DELETE_X = 185;
    private static final int ENTITY_DISPLAY_X = 30;
    private static final int ENTITY_DISPLAY_Y = 60;
    private static final int ENTITY_SCALE = 30;
    private static final int ENTITY_MOUSE_OFFSET_X = 20;
    private static final int UPDATE_INTERVAL_TICKS = 20;
    private int tickCounter = 0;
    private final Map<String, SpellRemoveButton> spellButtons = new HashMap<String, SpellRemoveButton>();

    public FamiliarScreen(FamiliarMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.f_97726_ = 199;
        this.f_97727_ = 101;
        this.f_97728_ = 8;
        this.f_97729_ = 5;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void m_7856_() {
        super.m_7856_();
        if (!((FamiliarMenu)this.f_97732_).hasClientData()) {
            return;
        }
        List<FamiliarMenu.SpellData> spells = ((FamiliarMenu)this.f_97732_).getSpellData();
        for (int i = 0; i < spells.size(); ++i) {
            FamiliarMenu.SpellData spell = spells.get(i);
            int yOffset = 67 + i * 10;
            SpellRemoveButton removeButton = new SpellRemoveButton(this.f_97735_ + 185, this.f_97736_ + yOffset, btn -> this.removeSpell(spell.name.getString()));
            this.m_142416_((GuiEventListener)removeButton);
        }
    }

    public void m_181908_() {
        super.m_181908_();
        ++this.tickCounter;
        if (this.tickCounter >= 20) {
            this.tickCounter = 0;
            if (!this.f_96541_.f_91074_.m_9236_().m_5776_() && !((FamiliarMenu)this.f_97732_).m_6875_((Player)this.f_96541_.f_91074_)) {
                this.m_7379_();
                return;
            }
            PacketHandler.network.sendToServer((Object)new RequestFamiliarDataUpdate());
        }
    }

    private void removeSpell(String spellName) {
        PacketHandler.network.sendToServer((Object)new RemoveFamiliarSpell(spellName));
        this.m_7379_();
    }

    private ItemStack getFrequencyIngot(FamiliarSpell.Frequency frequency) {
        return switch (frequency) {
            case FamiliarSpell.Frequency.IRON -> new ItemStack((ItemLike)Items.f_42416_);
            case FamiliarSpell.Frequency.GOLD -> new ItemStack((ItemLike)Items.f_42417_);
            case FamiliarSpell.Frequency.COPPER -> new ItemStack((ItemLike)Items.f_151052_);
            case FamiliarSpell.Frequency.SUPERHEATED_PURIFIED_VINTEUM -> new ItemStack((ItemLike)ItemInit.VINTEUM_INGOT_PURIFIED_SUPERHEATED.get());
            case FamiliarSpell.Frequency.PURIFIED_VINTEUM -> new ItemStack((ItemLike)ItemInit.PURIFIED_VINTEUM_INGOT.get());
            case FamiliarSpell.Frequency.TRANSMUTED_SILVER -> new ItemStack((ItemLike)ItemInit.TRANSMUTED_SILVER.get());
            default -> ItemStack.f_41583_;
        };
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        if (!((FamiliarMenu)this.f_97732_).hasClientData()) {
            return;
        }
        String familiarName = ((FamiliarMenu)this.f_97732_).getFamiliarName();
        if (familiarName != null && !familiarName.isEmpty()) {
            int nameWidth = this.f_96547_.m_92895_(familiarName);
            int centerX = (this.f_97726_ - nameWidth) / 2;
            pGuiGraphics.m_280056_(this.f_96547_, familiarName, centerX, 7, Color.WHITE.getRGB(), false);
        }
        String kOwner = Component.m_237115_((String)"gui.arcaneadditions.familiar.owner").getString() + ":";
        String vOwner = this.f_96541_.f_91074_.m_5446_().getString();
        pGuiGraphics.m_280056_(this.f_96547_, kOwner, 60, 17, Color.WHITE.getRGB(), false);
        pGuiGraphics.m_280056_(this.f_96547_, vOwner, 100, 17, Color.WHITE.getRGB(), false);
        String kType = Component.m_237115_((String)"gui.arcaneadditions.familiar.type").getString() + ":";
        String vType = Component.m_237115_((String)((FamiliarMenu)this.f_97732_).getFamiliarType()).getString();
        pGuiGraphics.m_280056_(this.f_96547_, kType, 60, 27, Color.WHITE.getRGB(), false);
        pGuiGraphics.m_280056_(this.f_96547_, vType, 100, 27, Color.WHITE.getRGB(), false);
        String kHealth = Component.m_237115_((String)"gui.arcaneadditions.familiar.health").getString() + ":";
        String vHealth = String.format("%.0f/%.0f", Float.valueOf(((FamiliarMenu)this.f_97732_).getFamiliarHealth()), Float.valueOf(((FamiliarMenu)this.f_97732_).getFamiliarMaxHealth()));
        pGuiGraphics.m_280056_(this.f_96547_, kHealth, 60, 37, Color.WHITE.getRGB(), false);
        pGuiGraphics.m_280056_(this.f_96547_, vHealth, 100, 37, Color.WHITE.getRGB(), false);
        String kMana = Component.m_237115_((String)"gui.arcaneadditions.familiar.mana").getString() + ":";
        String vMana = String.format("%.0f/%.0f", Float.valueOf(((FamiliarMenu)this.f_97732_).getMana()), Float.valueOf(((FamiliarMenu)this.f_97732_).getMaxMana()));
        pGuiGraphics.m_280056_(this.f_96547_, kMana, 60, 47, Color.WHITE.getRGB(), false);
        pGuiGraphics.m_280056_(this.f_96547_, vMana, 100, 47, Color.WHITE.getRGB(), false);
        List<FamiliarMenu.SpellData> spells = ((FamiliarMenu)this.f_97732_).getSpellData();
        String kSpellsKnown = Component.m_237115_((String)"gui.arcaneadditions.familiar.spells_known").getString();
        pGuiGraphics.m_280056_(this.f_96547_, kSpellsKnown, 60, 57, Color.WHITE.getRGB(), false);
        for (int i = 0; i < spells.size(); ++i) {
            FamiliarMenu.SpellData spell = spells.get(i);
            int yOffset = 67 + i * 10;
            int iconU = this.f_97726_ + (spell.offensive ? 7 : 0);
            boolean iconV = false;
            pGuiGraphics.m_280163_(TEXTURE, 60, yOffset, (float)iconU, (float)iconV, 7, 7, 256, 256);
            String spellName = spell.name.getString();
            String truncatedName = spellName.length() > 2 ? spellName.substring(1, spellName.length() - 1) : spellName;
            String spellText = truncatedName + " (" + (int)spell.manaCost + ")";
            pGuiGraphics.m_280056_(this.f_96547_, spellText, 70, yOffset, Color.WHITE.getRGB(), false);
            ItemStack frequencyIngot = this.getFrequencyIngot(spell.frequency);
            if (frequencyIngot.m_41619_()) continue;
            pGuiGraphics.m_280480_(frequencyIngot, 165, yOffset - 4);
        }
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float partialTicks, int mouse_x, int mouse_y) {
        this.m_280273_(pGuiGraphics);
        int xPos = this.f_97735_;
        int yPos = this.f_97736_;
        pGuiGraphics.m_280163_(TEXTURE, xPos, yPos, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
        if (!((FamiliarMenu)this.f_97732_).hasClientData()) {
            return;
        }
        try {
            EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(((FamiliarMenu)this.f_97732_).getFamiliarRegistryName()));
            if (entityType == null || this.f_96541_.f_91073_ == null) {
                return;
            }
            Mob displayEntity = (Mob)entityType.m_20615_((Level)this.f_96541_.f_91073_);
            if (displayEntity == null) {
                return;
            }
            if (((FamiliarMenu)this.f_97732_).getFamiliarNbt() != null) {
                displayEntity.m_20258_(((FamiliarMenu)this.f_97732_).getFamiliarNbt());
            }
            displayEntity.m_6593_(null);
            displayEntity.m_20340_(false);
            InventoryScreen.m_274545_((GuiGraphics)pGuiGraphics, (int)(xPos + 30), (int)(yPos + 60), (int)30, (float)((float)(xPos + 20) - (float)mouse_x), (float)((float)(yPos + 60) - (float)mouse_y), (LivingEntity)displayEntity);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean m_7467_(double pMouseX, double pMouseY, int pGuiLeft, int pGuiTop, int pMouseButton) {
        return pMouseX < (double)pGuiLeft || pMouseY < (double)pGuiTop || pMouseX >= (double)(pGuiLeft + this.f_97726_) || pMouseY >= (double)(pGuiTop + this.f_97727_);
    }

    public void updateFamiliarData(float health, float maxHealth, float mana, float maxMana) {
        ((FamiliarMenu)this.f_97732_).updateClientData(health, maxHealth, mana, maxMana);
    }
}

