/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.events.spells;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.sosly.arcaneadditions.capabilities.treestride.ITreestrideCapability;
import org.sosly.arcaneadditions.capabilities.treestride.TreestrideProvider;
import org.sosly.arcaneadditions.spells.components.TreeStrideComponent;
import org.sosly.arcaneadditions.utils.TreeFinder;

@Mod.EventBusSubscriber(modid="arcaneadditions", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TreeStrideEvents {
    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<?> event) {
        if (event.getObject() instanceof Level) {
            event.addCapability(ITreestrideCapability.TREESTRIDE_CAPABILITY, (ICapabilityProvider)new TreestrideProvider());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        ServerLevel level;
        BlockPos pos;
        block5: {
            block4: {
                ServerPlayer agent;
                LevelAccessor levelAccessor;
                BlockState blockState = event.getState();
                pos = event.getPos();
                if (!TreeFinder.isBlockALog(blockState) || event.isCanceled() || !((levelAccessor = event.getLevel()) instanceof ServerLevel)) break block4;
                level = (ServerLevel)levelAccessor;
                levelAccessor = event.getPlayer();
                if (levelAccessor instanceof ServerPlayer && blockState.canHarvestBlock((BlockGetter)level, pos, (Player)(agent = (ServerPlayer)levelAccessor))) break block5;
            }
            return;
        }
        if (!TreeFinder.isPartOfATree((Level)level, pos, true)) {
            return;
        }
        Set<BlockPos> roots = TreeFinder.getRootBlocks((Level)level, pos, blockPos -> TreeFinder.isBlockALog((Level)level, blockPos));
        BlockPos root = TreeStrideComponent.findRootBlock(roots, pos);
        level.getCapability(TreestrideProvider.TREESTRIDE).ifPresent(treestride -> treestride.removeDestination(root));
    }
}

