/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.events.spells;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.spells.ICanContainSpell;
import com.mna.api.spells.base.ISpellDefinition;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.sosly.arcaneadditions.effects.EffectRegistry;
import org.sosly.arcaneadditions.effects.beneficial.IceBlockEffect;
import org.sosly.arcaneadditions.entities.sorcery.IceBlockEntity;
import org.sosly.arcaneadditions.spells.components.IceBlockComponent;
import org.sosly.arcaneadditions.utils.World;

@Mod.EventBusSubscriber(modid="arcaneadditions", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class IceBlockEvents {
    @SubscribeEvent
    public static void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        IceBlockEvents.handleRestrictedActions((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onBreakingBlock(PlayerEvent.BreakSpeed event) {
        IceBlockEvents.handleRestrictedActions((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        IceBlockEvents.runOnEffect((Event)event, (instance, entity) -> {
            event.setCanceled(true);
            event.setAmount(0.0f);
            event.setResult(Event.Result.DENY);
        });
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        IceBlockEvents.handleRestrictedActions((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onHarvest(PlayerEvent.HarvestCheck event) {
        IceBlockEvents.handleRestrictedActions((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onItemInteract(PlayerInteractEvent.RightClickItem event) {
        IceBlockEvents.handleRestrictedActions((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        IceBlockEvents.handleRestrictedActions((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        IceBlockEvents.handleRestrictedActions((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        IceBlockEvents.handleRestrictedActions((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onPickup(PlayerEvent.ItemPickupEvent event) {
        IceBlockEvents.handleRestrictedActions((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onPotionAdded(MobEffectEvent.Added event) {
        IceBlockEvents.runOnEffect((Event)event, (instance, entity) -> {
            LivingEntity levelEntity;
            if (!(entity instanceof Player) && (levelEntity = (LivingEntity)World.getLevelEntity((Entity)entity)) != null) {
                levelEntity.m_147215_(instance, (Entity)entity);
            }
            entity.m_21310_(Integer.MAX_VALUE);
            entity.m_146917_(Integer.MAX_VALUE);
        });
    }

    @SubscribeEvent
    public static void onPotionExpired(MobEffectEvent.Expired event) {
        IceBlockEvents.runOnEffect((Event)event, (instance, entity) -> {
            LivingEntity levelEntity;
            if (!(entity instanceof Player) && (levelEntity = (LivingEntity)World.getLevelEntity((Entity)entity)) != null) {
                levelEntity.m_6234_(instance.m_19544_());
            }
            entity.m_21310_(0);
            entity.m_146917_(0);
            IceBlockEvents.removeIceBlockEntity(entity);
        });
    }

    @SubscribeEvent
    public static void onPotionRemoved(MobEffectEvent.Remove event) {
        IceBlockEvents.runOnEffect((Event)event, (instance, entity) -> {
            LivingEntity levelEntity;
            if (!(entity instanceof Player) && (levelEntity = (LivingEntity)World.getLevelEntity((Entity)entity)) != null) {
                levelEntity.m_6234_(instance.m_19544_());
            }
            entity.m_21310_(0);
            entity.m_146917_(0);
            IceBlockEvents.removeIceBlockEntity(entity);
        });
    }

    private static void removeIceBlockEntity(LivingEntity entity) {
        int iceBlockEntityId = entity.getPersistentData().m_128451_(IceBlockComponent.ICEBLOCK_ENTITY_ID);
        IceBlockEntity iceBlock = (IceBlockEntity)entity.m_9236_().m_6815_(iceBlockEntityId);
        if (iceBlock != null) {
            iceBlock.m_142687_(Entity.RemovalReason.DISCARDED);
            entity.getPersistentData().m_128473_(IceBlockComponent.ICEBLOCK_ENTITY_ID);
        }
        MobEffectInstance cooldown = new MobEffectInstance((MobEffect)EffectRegistry.ICE_BLOCK_EXHAUSTION.get(), 600, 0);
        entity.m_7292_(cooldown);
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        IceBlockEvents.handleRestrictedActions((LivingEvent)event);
    }

    private static void handleRestrictedActions(LivingEvent event) {
        IceBlockEvents.runOnEffect((Event)event, (instance, entity) -> {
            ItemStack stack = entity.m_21205_();
            if (stack.m_41720_() instanceof ICanContainSpell) {
                ISpellDefinition recipe = ManaAndArtificeMod.getSpellHelper().parseSpellDefinition(stack);
                AtomicBoolean isIceBlock = new AtomicBoolean(false);
                recipe.getComponents().forEach(component -> {
                    if (component.getPart() instanceof IceBlockComponent) {
                        isIceBlock.set(true);
                    }
                });
                if (isIceBlock.get()) {
                    return;
                }
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            if (event instanceof PlayerInteractEvent) {
                event.setResult(Event.Result.DENY);
            }
            if (event instanceof PlayerEvent.HarvestCheck) {
                ((PlayerEvent.HarvestCheck)event).setCanHarvest(false);
            }
            if (event instanceof LivingEvent.LivingJumpEvent) {
                entity.f_19812_ = false;
                entity.m_20334_(0.0, -2000.0, 0.0);
            }
        });
    }

    private static void runOnEffect(Event event, EffectRegistry.ILivingMobEffectInstanceHandler handler) {
        LivingEntity entity;
        if (event instanceof LivingEvent) {
            entity = ((LivingEvent)event).getEntity();
        } else if (event instanceof RenderLivingEvent) {
            RenderLivingEvent livingEvent = (RenderLivingEvent)event;
            entity = livingEvent.getEntity();
        } else {
            return;
        }
        if (event instanceof MobEffectEvent.Added) {
            MobEffectInstance instance = ((MobEffectEvent)event).getEffectInstance();
            MobEffect effect = instance.m_19544_();
            if (effect instanceof IceBlockEffect) {
                EffectRegistry.handle(handler, instance, entity);
            }
        } else {
            Collection effects = entity.m_21220_();
            for (MobEffectInstance instance : effects) {
                MobEffect effect = instance.m_19544_();
                if (!(effect instanceof IceBlockEffect)) continue;
                EffectRegistry.handle(handler, instance, entity);
            }
        }
    }
}

