/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.events.spells;

import com.mna.effects.beneficial.EffectPossession;
import java.util.Collection;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.sosly.arcaneadditions.effects.EffectRegistry;
import org.sosly.arcaneadditions.effects.neutral.AstralProjectionEffect;
import org.sosly.arcaneadditions.entities.sorcery.AstralProjectionEntity;

@Mod.EventBusSubscriber(modid="arcaneadditions", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AstralProjectionEvents {
    @SubscribeEvent
    public static void onProjectionMoved(LivingEvent event) {
        AstralProjectionEntity projection;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AstralProjectionEntity && (projection = (AstralProjectionEntity)livingEntity).m_20096_() && projection.getPersistentData().m_128457_("astral_magnitude") > 1.0f) {
            projection.m_6853_(false);
            projection.m_20242_(true);
        }
    }

    @SubscribeEvent
    public static void onPotionRemoved(MobEffectEvent.Remove event) {
        if (event.getEffect() instanceof EffectPossession) {
            LivingEntity entity2 = event.getEntity();
            if (entity2.m_9236_().m_5776_()) {
                return;
            }
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                player.m_21195_((MobEffect)EffectRegistry.ASTRAL_PROJECTION.get());
            }
        }
        AstralProjectionEvents.runOnEffect((Event)event, (instance, entity) -> {
            if (entity.m_9236_().m_5776_()) {
                return;
            }
            if (!(entity instanceof Player)) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        });
    }

    @SubscribeEvent
    public static void onPotionExpired(MobEffectEvent.Expired event) {
        AstralProjectionEvents.runOnEffect((Event)event, (instance, entity) -> {
            if (entity.m_9236_().m_5776_()) {
                return;
            }
            if (entity instanceof Player) {
                return;
            }
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        });
    }

    private static void runOnEffect(Event event, EffectRegistry.ILivingMobEffectInstanceHandler handler) {
        LivingEntity entity;
        if (event instanceof LivingEvent) {
            LivingEvent livingEvent = (LivingEvent)event;
            entity = livingEvent.getEntity();
        } else if (event instanceof RenderLivingEvent) {
            RenderLivingEvent livingEvent = (RenderLivingEvent)event;
            entity = livingEvent.getEntity();
        } else {
            return;
        }
        if (event instanceof MobEffectEvent.Added) {
            MobEffectInstance instance = ((MobEffectEvent)event).getEffectInstance();
            MobEffect effect = instance.m_19544_();
            if (effect instanceof AstralProjectionEffect) {
                EffectRegistry.handle(handler, instance, entity);
            }
        } else {
            Collection effects = entity.m_21220_();
            for (MobEffectInstance instance : effects) {
                MobEffect effect = instance.m_19544_();
                if (!(effect instanceof AstralProjectionEffect)) continue;
                EffectRegistry.handle(handler, instance, entity);
            }
        }
    }
}

