/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.events.entities;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.sosly.arcaneadditions.capabilities.familiar.FamiliarProvider;
import org.sosly.arcaneadditions.capabilities.familiar.IFamiliarCapability;
import org.sosly.arcaneadditions.utils.FamiliarHelper;

@Mod.EventBusSubscriber(modid="arcaneadditions", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FamiliarLifecycleHandler {
    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<?> event) {
        if (!(event.getObject() instanceof Player)) {
            return;
        }
        event.addCapability(IFamiliarCapability.FAMILIAR_CAPABILITY, (ICapabilityProvider)new FamiliarProvider());
    }

    @SubscribeEvent
    public static void onJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity = event.getEntity();
        if (entity instanceof Mob && FamiliarHelper.isFamiliar(mob = (Mob)entity) && FamiliarHelper.isOrphaned(mob)) {
            mob.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        IFamiliarCapability cap = FamiliarHelper.getFamiliarCapability((Player)player);
        if (cap == null) {
            return;
        }
        if (cap.getType() == null || cap.isBapped()) {
            return;
        }
        Mob existingFamiliar = cap.getFamiliar();
        if (existingFamiliar != null && !existingFamiliar.m_213877_() && existingFamiliar.m_9236_().m_46472_().equals(player.m_9236_().m_46472_())) {
            return;
        }
        if (existingFamiliar != null && existingFamiliar.m_213877_()) {
            cap.setFamiliar(null);
            cap.setFamiliarUUID(null);
        }
        if (existingFamiliar != null && !existingFamiliar.m_9236_().m_46472_().equals(player.m_9236_().m_46472_()) && cap.isOrderedToStay()) {
            return;
        }
        cap.setCaster((Player)player);
        cap.loadOnNextTick(event.getLevel(), player.m_20183_());
    }

    @SubscribeEvent
    public static void onLeaveLevel(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        IFamiliarCapability cap = FamiliarHelper.getFamiliarCapability((Player)player);
        if (cap == null) {
            return;
        }
        if (cap.isOrderedToStay()) {
            return;
        }
        Mob familiar = cap.getFamiliar();
        if (familiar == null) {
            return;
        }
        cap.storeFamiliarData();
        familiar.m_142687_(Entity.RemovalReason.DISCARDED);
        cap.setFamiliar(null);
        cap.setFamiliarUUID(null);
    }

    @SubscribeEvent
    public static void onFamiliarTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
            IFamiliarCapability cap = FamiliarHelper.getFamiliarCapability((Player)player);
            if (cap == null) continue;
            cap.tick();
        }
    }

    @SubscribeEvent
    public static void onFamiliarDeath(LivingDeathEvent event) {
        Mob mob;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob) || !FamiliarHelper.isFamiliar(mob = (Mob)livingEntity)) {
            return;
        }
        Player caster = FamiliarHelper.getCaster(mob);
        if (caster == null) {
            return;
        }
        IFamiliarCapability cap = FamiliarHelper.getFamiliarCapability(caster);
        if (cap == null) {
            return;
        }
        cap.reset();
    }
}

