/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.entities.ai;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.spells.shapes.ShapeSelf;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import org.sosly.arcaneadditions.config.ServerConfig;
import org.sosly.arcaneadditions.entities.ai.AbstractFamiliarGoal;
import org.sosly.arcaneadditions.spells.FamiliarSpell;
import org.sosly.arcaneadditions.spells.shapes.FamiliarShape;
import org.sosly.arcaneadditions.spells.shapes.SharedShape;

public class CastUtilitySpell
extends AbstractFamiliarGoal {
    private final float maxCastDistance;
    private boolean hasCast = false;
    private boolean cannotCast;
    private double distance = 0.0;
    private long lastAttempt = -1L;
    private Optional<FamiliarSpell> spellToCast = Optional.empty();
    private LivingEntity target;
    private int seeTime;
    private boolean strafingBackwards;
    private boolean strafingClockwise;
    private int strafingTime = -1;

    public CastUtilitySpell(Mob familiar, float maxCastDistance) {
        super(familiar);
        this.maxCastDistance = maxCastDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.hasValidCapability() || this.isOrderedToStay() || this.isBapped()) {
            return false;
        }
        if (this.capability.getSpellsKnown().isEmpty()) {
            return false;
        }
        long currentTime = this.familiar.m_20194_().m_129783_().m_46467_();
        boolean hasAvailableSpell = this.capability.getSpellsKnown().stream().filter(spell -> !spell.isOffensive()).anyMatch(spell -> {
            long sinceLastCast = currentTime - spell.getLastCast();
            return sinceLastCast >= (long)(spell.getFrequency().getSeconds() * 20);
        });
        if (!hasAvailableSpell) {
            return false;
        }
        long sinceLastAttempt = currentTime - this.lastAttempt;
        if (sinceLastAttempt < (long)ServerConfig.spellCastAttemptCooldown) {
            return false;
        }
        return hasAvailableSpell;
    }

    public boolean m_8045_() {
        if (this.hasCast) {
            return false;
        }
        if (!this.hasValidCapability() || this.isOrderedToStay()) {
            return false;
        }
        if (!this.spellToCast.isPresent()) {
            return false;
        }
        float mana = this.spellToCast.get().getRecipe().getManaCost();
        if (this.capability.getCastingResource().getAmount() < mana + (float)ServerConfig.spellMinimumManaBuffer) {
            return false;
        }
        return this.target != null && !this.target.m_213877_();
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_6767_() {
        return false;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.hasCast = false;
        this.lastAttempt = this.familiar.m_20194_().m_129783_().m_46467_();
        this.selectSpellToCast();
        if (!this.spellToCast.isPresent()) {
            this.cannotCast = true;
            return;
        }
        FamiliarSpell spell = this.spellToCast.get();
        if (spell.getRecipe().getShape() == null) {
            return;
        }
        Shape shape = (Shape)spell.getRecipe().getShape().getPart();
        if (shape instanceof FamiliarShape || shape instanceof SharedShape || shape instanceof ShapeSelf) {
            this.target = this.familiar;
            this.distance = 0.0;
            return;
        }
        this.target = this.getCaster();
        if (this.target == null) {
            return;
        }
        this.distance = switch (shape.getClass().getSimpleName()) {
            case "ShapeProjectile" -> this.maxCastDistance;
            case "ShapeBeam", "ShapeCone" -> Math.min(8.0, (double)this.maxCastDistance);
            default -> Math.max(spell.getRecipe().getShape().getValue(Attribute.RANGE), 4.0f);
        };
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.hasCast = false;
        this.cannotCast = false;
        this.target = null;
        this.spellToCast = Optional.empty();
        this.seeTime = 0;
        this.strafingTime = -1;
        this.distance = 0.0;
    }

    public void m_8037_() {
        if (this.target.equals((Object)this.familiar)) {
            this.castSpellOnSelf();
            return;
        }
        double distanceToTarget = this.familiar.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        this.updateSeeTime();
        if (this.shouldStrafe(distanceToTarget)) {
            this.familiar.m_21573_().m_26573_();
            ++this.strafingTime;
        } else {
            this.familiar.m_21573_().m_5624_((Entity)this.target, ServerConfig.spellNavigationSpeed);
            this.strafingTime = -1;
        }
        this.updateStrafingBehavior(distanceToTarget);
        if (distanceToTarget > this.distance) {
            return;
        }
        this.familiar.m_21573_().m_26573_();
        this.familiar.m_21563_().m_24960_((Entity)this.target, (float)ServerConfig.spellLookAtSpeed, (float)ServerConfig.spellLookAtSpeed);
        this.familiar.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        ManaAndArtificeMod.getSpellHelper().affect(this.spellToCast.get().getRecipe().createAsSpell(), (ISpellDefinition)this.spellToCast.get().getRecipe(), this.familiar.m_9236_(), new SpellSource((LivingEntity)this.familiar, InteractionHand.MAIN_HAND), new SpellTarget((Entity)this.target));
        float mana = this.spellToCast.get().getRecipe().getManaCost();
        this.capability.getCastingResource().consume((LivingEntity)this.familiar, mana);
        this.hasCast = true;
        this.spellToCast.get().setLastCast(this.familiar.m_20194_().m_129783_().m_46467_());
    }

    private void castSpellOnSelf() {
        this.familiar.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        ManaAndArtificeMod.getSpellHelper().affect(this.spellToCast.get().getRecipe().createAsSpell(), (ISpellDefinition)this.spellToCast.get().getRecipe(), this.familiar.m_9236_(), new SpellSource((LivingEntity)this.familiar, InteractionHand.MAIN_HAND), new SpellTarget((Entity)this.familiar));
        this.hasCast = true;
    }

    private void selectSpellToCast() {
        long currentTime = this.familiar.m_20194_().m_129783_().m_46467_();
        this.spellToCast = this.capability.getSpellsKnown().stream().filter(spell -> !spell.isOffensive()).filter(spell -> {
            long sinceLastCast = currentTime - spell.getLastCast();
            return sinceLastCast >= (long)(spell.getFrequency().getSeconds() * 20);
        }).findAny();
    }

    private void updateSeeTime() {
        boolean positiveSeeTime;
        boolean canSee = this.familiar.m_21574_().m_148306_((Entity)this.target);
        boolean bl = positiveSeeTime = this.seeTime > 0;
        if (canSee != positiveSeeTime) {
            this.seeTime = 0;
        }
        this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
    }

    private boolean shouldStrafe(double distanceToTarget) {
        return distanceToTarget <= this.distance && distanceToTarget <= (double)this.maxCastDistance && this.seeTime >= ServerConfig.spellSightRequiredTime;
    }

    private void updateStrafingBehavior(double distanceToTarget) {
        if (this.strafingTime >= ServerConfig.spellStrafingRecalcTime) {
            this.recalculateStrafingDirection();
            this.strafingTime = 0;
        }
        if (this.strafingTime < -1) {
            this.familiar.m_21563_().m_24960_((Entity)this.target, (float)ServerConfig.spellLookAtSpeed, (float)ServerConfig.spellLookAtSpeed);
            return;
        }
        this.adjustStrafingDistance(distanceToTarget);
        this.performStrafing();
    }

    private void recalculateStrafingDirection() {
        if ((double)this.familiar.m_217043_().m_188501_() < ServerConfig.spellStrafingChance) {
            boolean bl = this.strafingClockwise = !this.strafingClockwise;
        }
        if ((double)this.familiar.m_217043_().m_188501_() < ServerConfig.spellStrafingChance) {
            this.strafingBackwards = !this.strafingBackwards;
        }
    }

    private void adjustStrafingDistance(double distanceToTarget) {
        if (distanceToTarget > this.distance * ServerConfig.spellStrafingBackwardThreshold) {
            this.strafingBackwards = false;
            return;
        }
        if (distanceToTarget < this.distance * ServerConfig.spellStrafingForwardThreshold) {
            this.strafingBackwards = true;
        }
    }

    private void performStrafing() {
        float forward = this.strafingBackwards ? -0.5f : 0.5f;
        float strafe = this.strafingClockwise ? 0.5f : -0.5f;
        this.familiar.m_21566_().m_24988_(forward * (float)ServerConfig.spellStrafingSpeed, strafe * (float)ServerConfig.spellStrafingSpeed);
        this.familiar.m_21391_((Entity)this.target, (float)ServerConfig.spellLookAtSpeed, (float)ServerConfig.spellLookAtSpeed);
    }
}

