/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.effects.beneficial;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.capabilities.resource.ICastingResource;
import java.lang.ref.WeakReference;
import java.util.Objects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.sosly.arcaneadditions.capabilities.polymorph.PolymorphProvider;
import org.sosly.arcaneadditions.effects.EffectRegistry;

public class PolymorphEffect
extends MobEffect {
    public PolymorphEffect() {
        super(MobEffectCategory.NEUTRAL, 0);
    }

    public void m_6742_(@NotNull LivingEntity entity, int amplifier) {
        if (!(entity instanceof Player)) {
            return;
        }
        entity.getCapability(PolymorphProvider.POLYMORPH).ifPresent(polymorph -> {
            float complexity = polymorph.getComplexity();
            WeakReference<Player> caster = polymorph.getCaster(entity.m_9236_());
            if (caster == null) {
                entity.m_21195_((MobEffect)EffectRegistry.POLYMORPH.get());
                return;
            }
            Objects.requireNonNull((Player)caster.get()).getCapability(ManaAndArtificeMod.getMagicCapability(), null).ifPresent(magic -> {
                ICastingResource resource = magic.getCastingResource();
                if (resource.getAmount() < complexity) {
                    entity.m_21195_((MobEffect)EffectRegistry.POLYMORPH.get());
                } else {
                    resource.consume(entity, complexity);
                }
            });
        });
    }

    public boolean m_6584_(int durationTicks, int amplifier) {
        int MANA_COST_FREQUENCY = 20;
        return durationTicks % MANA_COST_FREQUENCY == 0;
    }
}

