/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.effects;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.sosly.arcaneadditions.effects.beneficial.AntiMagicEffect;
import org.sosly.arcaneadditions.effects.beneficial.IceBlockEffect;
import org.sosly.arcaneadditions.effects.beneficial.LifeLinkEffect;
import org.sosly.arcaneadditions.effects.beneficial.PolymorphEffect;
import org.sosly.arcaneadditions.effects.harmful.EnragedEffect;
import org.sosly.arcaneadditions.effects.neutral.AstralProjectionEffect;
import org.sosly.arcaneadditions.effects.neutral.IceBlockExhaustionEffect;

public class EffectRegistry {
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"arcaneadditions");
    public static final RegistryObject<AntiMagicEffect> ANTI_MAGIC = EFFECTS.register("anti_magic", AntiMagicEffect::new);
    public static final RegistryObject<AstralProjectionEffect> ASTRAL_PROJECTION = EFFECTS.register("astral_projection", AstralProjectionEffect::new);
    public static final RegistryObject<EnragedEffect> ENRAGED = EFFECTS.register("enraged", EnragedEffect::new);
    public static final RegistryObject<IceBlockEffect> ICE_BLOCK = EFFECTS.register("ice_block", IceBlockEffect::new);
    public static final RegistryObject<IceBlockExhaustionEffect> ICE_BLOCK_EXHAUSTION = EFFECTS.register("ice_block-exhaustion", IceBlockExhaustionEffect::new);
    public static final RegistryObject<LifeLinkEffect> LIFE_LINK = EFFECTS.register("life_link", LifeLinkEffect::new);
    public static final RegistryObject<PolymorphEffect> POLYMORPH = EFFECTS.register("polymorph", PolymorphEffect::new);

    public static void handle(ILivingMobEffectInstanceHandler handler, MobEffectInstance inst, LivingEntity entity) {
        handler.handle(inst, entity);
    }

    @FunctionalInterface
    public static interface ILivingMobEffectInstanceHandler {
        public void handle(MobEffectInstance var1, LivingEntity var2);
    }
}

