/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="arcaneadditions", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ServerConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.ConfigValue<List<String>> FAMILIARS;
    private static final ForgeConfigSpec.BooleanValue POLYMORPH_ALLOW_SPELLCASTING;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<String>>> POLYMORPH_TIERS;
    private static final ForgeConfigSpec.ConfigValue<List<String>> SOUL_SEARCHERS_LENS_CREATURE_MODIFIERS;
    private static final ForgeConfigSpec.IntValue SOUL_SEARCHERS_LENS_HEALTH_PER_LEVEL;
    private static final ForgeConfigSpec.IntValue SOUL_SEARCHERS_LENS_MAX_DISTANCE;
    private static final ForgeConfigSpec.DoubleValue FAMILIAR_STAY_DISTANCE_THRESHOLD;
    private static final ForgeConfigSpec.IntValue FAMILIAR_TELEPORT_DISTANCE;
    private static final ForgeConfigSpec.IntValue FAMILIAR_TELEPORT_ATTEMPTS;
    private static final ForgeConfigSpec.IntValue FAMILIAR_PATH_RECALC_DELAY;
    private static final ForgeConfigSpec.DoubleValue FAMILIAR_LOOK_AT_SPEED;
    private static final ForgeConfigSpec.IntValue SPELL_CAST_ATTEMPT_COOLDOWN;
    private static final ForgeConfigSpec.IntValue SPELL_MINIMUM_MANA_BUFFER;
    private static final ForgeConfigSpec.IntValue SPELL_SIGHT_REQUIRED_TIME;
    private static final ForgeConfigSpec.IntValue SPELL_STRAFING_RECALC_TIME;
    private static final ForgeConfigSpec.DoubleValue SPELL_STRAFING_CHANCE;
    private static final ForgeConfigSpec.DoubleValue SPELL_STRAFING_SPEED;
    private static final ForgeConfigSpec.DoubleValue SPELL_STRAFING_BACKWARD_THRESHOLD;
    private static final ForgeConfigSpec.DoubleValue SPELL_STRAFING_FORWARD_THRESHOLD;
    private static final ForgeConfigSpec.DoubleValue SPELL_LOOK_AT_SPEED;
    private static final ForgeConfigSpec.DoubleValue SPELL_NAVIGATION_SPEED;
    private static final ForgeConfigSpec.IntValue WANDER_IDLE_THRESHOLD;
    private static final ForgeConfigSpec.IntValue WANDER_SEARCH_RADIUS;
    private static final ForgeConfigSpec.IntValue WANDER_SEARCH_HEIGHT;
    private static final ForgeConfigSpec.IntValue WANDER_MAX_ATTEMPTS;
    private static final ForgeConfigSpec.DoubleValue FAMILIAR_HEALING_RATE;
    private static final ForgeConfigSpec.IntValue FAMILIAR_HEALING_TICK_INTERVAL;
    public static final ForgeConfigSpec SPEC;
    public static List<String> familiars;
    public static boolean polymorphAllowSpellcasting;
    public static List<? extends List<String>> polymorphTiers;
    public static List<String> soulSearchersLensCreatureModifiers;
    public static int soulSearchersLensHealthPerLevel;
    public static int soulSearchersLensMaxDistance;
    public static double familiarStayDistanceThreshold;
    public static int familiarTeleportDistance;
    public static int familiarTeleportAttempts;
    public static int familiarPathRecalcDelay;
    public static double familiarLookAtSpeed;
    public static int spellCastAttemptCooldown;
    public static int spellMinimumManaBuffer;
    public static int spellSightRequiredTime;
    public static int spellStrafingRecalcTime;
    public static double spellStrafingChance;
    public static double spellStrafingSpeed;
    public static double spellStrafingBackwardThreshold;
    public static double spellStrafingForwardThreshold;
    public static double spellLookAtSpeed;
    public static double spellNavigationSpeed;
    public static int wanderIdleThreshold;
    public static int wanderSearchRadius;
    public static int wanderSearchHeight;
    public static int wanderMaxAttempts;
    public static double familiarHealingRate;
    public static int familiarHealingTickInterval;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        familiars = (List)FAMILIARS.get();
        polymorphAllowSpellcasting = (Boolean)POLYMORPH_ALLOW_SPELLCASTING.get();
        polymorphTiers = (List)POLYMORPH_TIERS.get();
        soulSearchersLensCreatureModifiers = (List)SOUL_SEARCHERS_LENS_CREATURE_MODIFIERS.get();
        soulSearchersLensHealthPerLevel = (Integer)SOUL_SEARCHERS_LENS_HEALTH_PER_LEVEL.get();
        soulSearchersLensMaxDistance = (Integer)SOUL_SEARCHERS_LENS_MAX_DISTANCE.get();
        familiarStayDistanceThreshold = (Double)FAMILIAR_STAY_DISTANCE_THRESHOLD.get();
        familiarTeleportDistance = (Integer)FAMILIAR_TELEPORT_DISTANCE.get();
        familiarTeleportAttempts = (Integer)FAMILIAR_TELEPORT_ATTEMPTS.get();
        familiarPathRecalcDelay = (Integer)FAMILIAR_PATH_RECALC_DELAY.get();
        familiarLookAtSpeed = (Double)FAMILIAR_LOOK_AT_SPEED.get();
        spellCastAttemptCooldown = (Integer)SPELL_CAST_ATTEMPT_COOLDOWN.get();
        spellMinimumManaBuffer = (Integer)SPELL_MINIMUM_MANA_BUFFER.get();
        spellSightRequiredTime = (Integer)SPELL_SIGHT_REQUIRED_TIME.get();
        spellStrafingRecalcTime = (Integer)SPELL_STRAFING_RECALC_TIME.get();
        spellStrafingChance = (Double)SPELL_STRAFING_CHANCE.get();
        spellStrafingSpeed = (Double)SPELL_STRAFING_SPEED.get();
        spellStrafingBackwardThreshold = (Double)SPELL_STRAFING_BACKWARD_THRESHOLD.get();
        spellStrafingForwardThreshold = (Double)SPELL_STRAFING_FORWARD_THRESHOLD.get();
        spellLookAtSpeed = (Double)SPELL_LOOK_AT_SPEED.get();
        spellNavigationSpeed = (Double)SPELL_NAVIGATION_SPEED.get();
        wanderIdleThreshold = (Integer)WANDER_IDLE_THRESHOLD.get();
        wanderSearchRadius = (Integer)WANDER_SEARCH_RADIUS.get();
        wanderSearchHeight = (Integer)WANDER_SEARCH_HEIGHT.get();
        wanderMaxAttempts = (Integer)WANDER_MAX_ATTEMPTS.get();
        familiarHealingRate = (Double)FAMILIAR_HEALING_RATE.get();
        familiarHealingTickInterval = (Integer)FAMILIAR_HEALING_TICK_INTERVAL.get();
    }

    public static <T> boolean isValidEntityList(T entry) {
        if (!(entry instanceof List)) {
            return false;
        }
        for (Object i : (List)entry) {
            if (!(i instanceof String)) {
                return false;
            }
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation((String)i));
            if (type != null) continue;
            return false;
        }
        return true;
    }

    private static List<List<String>> getDefaultPolymorphTiers() {
        ArrayList<String> tier1polymorphs = new ArrayList<String>();
        ArrayList<String> tier2polymorphs = new ArrayList<String>();
        ArrayList<String> tier3polymorphs = new ArrayList<String>();
        ArrayList<String> tier4polymorphs = new ArrayList<String>();
        tier1polymorphs.addAll(Arrays.asList("minecraft:cat", "minecraft:chicken", "minecraft:cow", "minecraft:donkey", "minecraft:fox", "minecraft:goat", "minecraft:horse", "minecraft:llama", "minecraft:mule", "minecraft:ocelot", "minecraft:panda", "minecraft:pig", "minecraft:rabbit", "minecraft:sheep", "minecraft:spider", "minecraft:wolf"));
        tier2polymorphs.addAll(Arrays.asList("minecraft:axolotl", "minecraft:bat", "minecraft:bee", "minecraft:cave_spider", "minecraft:cod", "minecraft:dolphin", "minecraft:mooshroom", "minecraft:parrot", "minecraft:pufferfish", "minecraft:salmon", "minecraft:polar_bear", "minecraft:squid", "minecraft:tropical_fish", "minecraft:turtle"));
        tier3polymorphs.addAll(Arrays.asList("minecraft:creeper", "minecraft:drowned", "minecraft:glow_squid", "minecraft:husk", "minecraft:iron_golem", "minecraft:piglin", "minecraft:ravager", "minecraft:silverfish", "minecraft:skeleton", "minecraft:skeleton_horse", "minecraft:slime", "minecraft:snow_golem", "minecraft:stray", "minecraft:strider", "minecraft:zombie", "minecraft:zombie_horse", "minecraft:zombified_piglin"));
        tier4polymorphs.addAll(Arrays.asList("minecraft:blaze", "minecraft:enderman", "minecraft:endermite", "minecraft:ghast", "minecraft:giant", "minecraft:guardian", "minecraft:hoglin", "minecraft:magma_cube", "minecraft:phantom", "minecraft:piglin_brute", "minecraft:shulker", "minecraft:vex", "minecraft:wither_skeleton", "minecraft:zoglin"));
        return Arrays.asList(tier1polymorphs, tier2polymorphs, tier3polymorphs, tier4polymorphs);
    }

    static {
        BUILDER.push("familiars");
        BUILDER.comment("Familiar settings");
        FAMILIARS = BUILDER.comment("A list of entity types that can be bound as familiars.").translation("config.arcaneadditions.familiars").define("familiars", List.of("minecraft:bat", "minecraft:cat", "minecraft:parrot", "minecraft:fox", "minecraft:rabbit", "minecraft:chicken", "minecraft:allay"), ServerConfig::isValidEntityList);
        BUILDER.pop();
        BUILDER.push("polymorph");
        BUILDER.comment("Polymorph settings");
        POLYMORPH_ALLOW_SPELLCASTING = BUILDER.comment("If true, players will be able to cast spells while polymorphed.").translation("config.arcaneadditions.polymorph_allow_spellcasting_while_polymorphed").define("allowSpellcastingWhilePolymorphed", false);
        POLYMORPH_TIERS = BUILDER.comment("A list of polymorph tiers, each of which is a list of entity IDs and their corresponding polymorph spell IDs.").translation("config.arcaneadditions.polymorph_tiers").defineList("morphTiers", ServerConfig.getDefaultPolymorphTiers(), it -> it instanceof List);
        BUILDER.pop();
        BUILDER.push("soulsearchers_lens");
        BUILDER.comment("Soul Searcher's Lens settings");
        SOUL_SEARCHERS_LENS_CREATURE_MODIFIERS = BUILDER.comment("An (optional) list of modifiers for specific creatures health values for determining the XP required to study that creature").translation("config.arcaneadditions.soulsearchers_lens_creature_modifiers").define("creatureModifiers", List.of("minecraft:villager,1.5"));
        SOUL_SEARCHERS_LENS_HEALTH_PER_LEVEL = BUILDER.comment("For every multiple of this number that a creature has in max health, the player must spend a level to progress their phylactery progress.").translation("config.arcaneadditions.soulsearchers_lens_health_per_level").defineInRange("healthPerLevel", 20, 1, Integer.MAX_VALUE);
        SOUL_SEARCHERS_LENS_MAX_DISTANCE = BUILDER.comment("This setting determines how many blocks away the player can be as they continue to study their target.").translation("config.arcaneadditions.soulsearchers_lens_max_distance").defineInRange("maxDistance", 5, 1, 32);
        BUILDER.pop();
        BUILDER.push("familiar_ai");
        BUILDER.comment("Familiar AI behavior settings");
        FAMILIAR_STAY_DISTANCE_THRESHOLD = BUILDER.comment("Distance in blocks at which familiar ignores stay order if caster is hurt").translation("config.arcaneadditions.familiar_stay_distance_threshold").defineInRange("stayDistanceThreshold", 144.0, 1.0, 1024.0);
        FAMILIAR_TELEPORT_DISTANCE = BUILDER.comment("Random blocks offset when teleporting to caster").translation("config.arcaneadditions.familiar_teleport_distance").defineInRange("teleportDistance", 3, 1, 10);
        FAMILIAR_TELEPORT_ATTEMPTS = BUILDER.comment("Maximum attempts to find safe teleport location").translation("config.arcaneadditions.familiar_teleport_attempts").defineInRange("teleportAttempts", 10, 1, 50);
        FAMILIAR_PATH_RECALC_DELAY = BUILDER.comment("Ticks between path recalculations").translation("config.arcaneadditions.familiar_path_recalc_delay").defineInRange("pathRecalcDelay", 10, 1, 100);
        FAMILIAR_LOOK_AT_SPEED = BUILDER.comment("Rotation speed when looking at caster").translation("config.arcaneadditions.familiar_look_at_speed").defineInRange("lookAtSpeed", 10.0, 1.0, 45.0);
        SPELL_CAST_ATTEMPT_COOLDOWN = BUILDER.comment("Minimum ticks between spell cast attempts").translation("config.arcaneadditions.spell_cast_attempt_cooldown").defineInRange("spellCastAttemptCooldown", 20, 1, 100);
        SPELL_MINIMUM_MANA_BUFFER = BUILDER.comment("Mana to keep in reserve after casting").translation("config.arcaneadditions.spell_minimum_mana_buffer").defineInRange("spellMinimumManaBuffer", 10, 0, 100);
        SPELL_SIGHT_REQUIRED_TIME = BUILDER.comment("Ticks target must be visible before casting").translation("config.arcaneadditions.spell_sight_required_time").defineInRange("spellSightRequiredTime", 20, 1, 100);
        SPELL_STRAFING_RECALC_TIME = BUILDER.comment("Ticks before changing strafe direction").translation("config.arcaneadditions.spell_strafing_recalc_time").defineInRange("spellStrafingRecalcTime", 20, 1, 100);
        SPELL_STRAFING_CHANCE = BUILDER.comment("Chance to change strafe direction").translation("config.arcaneadditions.spell_strafing_chance").defineInRange("spellStrafingChance", 0.3, 0.0, 1.0);
        SPELL_STRAFING_SPEED = BUILDER.comment("Movement speed multiplier while strafing").translation("config.arcaneadditions.spell_strafing_speed").defineInRange("spellStrafingSpeed", 0.5, 0.1, 2.0);
        SPELL_STRAFING_BACKWARD_THRESHOLD = BUILDER.comment("Distance ratio to stop backing up").translation("config.arcaneadditions.spell_strafing_backward_threshold").defineInRange("spellStrafingBackwardThreshold", 0.75, 0.1, 1.0);
        SPELL_STRAFING_FORWARD_THRESHOLD = BUILDER.comment("Distance ratio to start backing up").translation("config.arcaneadditions.spell_strafing_forward_threshold").defineInRange("spellStrafingForwardThreshold", 0.25, 0.1, 1.0);
        SPELL_LOOK_AT_SPEED = BUILDER.comment("Rotation speed when targeting for spells").translation("config.arcaneadditions.spell_look_at_speed").defineInRange("spellLookAtSpeed", 30.0, 1.0, 90.0);
        SPELL_NAVIGATION_SPEED = BUILDER.comment("Movement speed toward spell target").translation("config.arcaneadditions.spell_navigation_speed").defineInRange("spellNavigationSpeed", 1.0, 0.1, 3.0);
        WANDER_IDLE_THRESHOLD = BUILDER.comment("No-action ticks before wandering").translation("config.arcaneadditions.wander_idle_threshold").defineInRange("wanderIdleThreshold", 100, 20, 1000);
        WANDER_SEARCH_RADIUS = BUILDER.comment("Horizontal blocks to search for wander target").translation("config.arcaneadditions.wander_search_radius").defineInRange("wanderSearchRadius", 10, 1, 32);
        WANDER_SEARCH_HEIGHT = BUILDER.comment("Vertical blocks to search for wander target").translation("config.arcaneadditions.wander_search_height").defineInRange("wanderSearchHeight", 7, 1, 16);
        WANDER_MAX_ATTEMPTS = BUILDER.comment("Maximum attempts to find valid wander position").translation("config.arcaneadditions.wander_max_attempts").defineInRange("wanderMaxAttempts", 10, 1, 50);
        FAMILIAR_HEALING_RATE = BUILDER.comment("Mana cost per health point when familiar heals").translation("config.arcaneadditions.familiar_healing_rate").defineInRange("familiarHealingRate", 25.0, 1.0, 100.0);
        FAMILIAR_HEALING_TICK_INTERVAL = BUILDER.comment("Ticks between familiar healing attempts").translation("config.arcaneadditions.familiar_healing_tick_interval").defineInRange("familiarHealingTickInterval", 20, 1, 200);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

