/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.capabilities.treestride;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.sosly.arcaneadditions.capabilities.treestride.ITreestrideCapability;

public class TreestrideCapability
implements ITreestrideCapability {
    final Map<BlockPos, Set<UUID>> blocksToPlayers = new HashMap<BlockPos, Set<UUID>>();
    final Map<UUID, Map<BlockPos, String>> playersToBlocks = new HashMap<UUID, Map<BlockPos, String>>();
    final Map<ServerPlayer, BlockPos> playerPositions = new HashMap<ServerPlayer, BlockPos>();

    @Override
    public void addDestination(Player player, String name, BlockPos pos) {
        UUID uuid = player.m_20148_();
        this.addDestination(uuid, name, pos);
    }

    @Override
    public void addDestination(UUID uuid, String name, BlockPos pos) {
        this.synchronizeDataMaps(uuid, pos);
        Set<UUID> blockData = this.getBlocksToPlayers(pos);
        Map<BlockPos, String> playerData = this.getPlayersToBlocks(uuid);
        blockData.add(uuid);
        this.blocksToPlayers.put(pos, blockData);
        playerData.put(pos, name);
        this.playersToBlocks.put(uuid, playerData);
    }

    @Override
    public void clearCurrentPosition(ServerPlayer player) {
        this.playerPositions.remove(player);
    }

    @Override
    public void removeDestination(BlockPos pos) {
        Set<UUID> blockData = this.getBlocksToPlayers(pos);
        for (UUID uuid : blockData) {
            Map<BlockPos, String> playerData = this.getPlayersToBlocks(uuid);
            if (playerData.isEmpty()) continue;
            playerData.remove(pos);
        }
        this.blocksToPlayers.remove(pos);
    }

    @Override
    public void removeDestination(ServerPlayer player, BlockPos pos) {
        UUID uuid = player.m_20148_();
        Set<UUID> blockData = this.getBlocksToPlayers(pos);
        blockData.remove(uuid);
        Map<BlockPos, String> playerData = this.getPlayersToBlocks(uuid);
        playerData.remove(pos);
    }

    @Override
    public void reset() {
        this.blocksToPlayers.clear();
        this.playersToBlocks.clear();
    }

    @Override
    public void setCurrentPosition(ServerPlayer player, BlockPos pos) {
        this.playerPositions.put(player, pos);
    }

    @Override
    public Map<BlockPos, String> getPlayerDestinations(Player player) {
        return this.playersToBlocks.get(player.m_20148_());
    }

    @Override
    public Map<UUID, Map<BlockPos, String>> getAllDestinations() {
        return this.playersToBlocks;
    }

    @Override
    @Nullable
    public BlockPos getCurrentPosition(ServerPlayer player) {
        return this.playerPositions.getOrDefault(player, null);
    }

    private Set<UUID> getBlocksToPlayers(BlockPos pos) {
        return this.blocksToPlayers.getOrDefault(pos, new HashSet());
    }

    private Map<BlockPos, String> getPlayersToBlocks(UUID uuid) {
        return this.playersToBlocks.getOrDefault(uuid, new HashMap());
    }

    private void synchronizeDataMaps(UUID uuid, BlockPos pos) {
        Set<UUID> blockData = this.getBlocksToPlayers(pos);
        Map<BlockPos, String> playerData = this.getPlayersToBlocks(uuid);
        if (blockData.contains(uuid) && !playerData.containsKey(pos)) {
            blockData.remove(uuid);
            this.blocksToPlayers.put(pos, blockData);
        }
        if (!blockData.contains(uuid) && playerData.containsKey(pos)) {
            playerData.remove(pos);
            this.playersToBlocks.put(uuid, playerData);
        }
    }
}

