/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.capabilities.polymorph;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sosly.arcaneadditions.capabilities.polymorph.IPolymorphCapability;
import org.sosly.arcaneadditions.capabilities.polymorph.PolymorphCapability;

public class PolymorphProvider
implements ICapabilitySerializable<Tag> {
    public static final Capability<IPolymorphCapability> POLYMORPH = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPolymorphCapability>(){});
    private final LazyOptional<IPolymorphCapability> holder = LazyOptional.of(PolymorphCapability::new);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return POLYMORPH.orEmpty(cap, this.holder);
    }

    public Tag serializeNBT() {
        IPolymorphCapability instance = (IPolymorphCapability)this.holder.orElse((Object)new PolymorphCapability());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("complexity", instance.getComplexity());
        nbt.m_128350_("health", instance.getHealth());
        if (instance.getCasterUUID() != null) {
            nbt.m_128362_("caster", instance.getCasterUUID());
        }
        return nbt;
    }

    public void deserializeNBT(Tag nbt) {
        IPolymorphCapability instance = (IPolymorphCapability)this.holder.orElse((Object)new PolymorphCapability());
        if (nbt instanceof CompoundTag) {
            CompoundTag cnbt = (CompoundTag)nbt;
            if (cnbt.m_128441_("complexity")) {
                instance.setComplexity(cnbt.m_128457_("complexity"));
            }
            if (cnbt.m_128441_("health")) {
                instance.setHealth(cnbt.m_128457_("health"));
            }
            if (cnbt.m_128441_("caster")) {
                instance.setCasterUUID(cnbt.m_128342_("caster"));
            }
        }
    }
}

