/*
 * Decompiled with CFR 0.152.
 */
package org.sosly.arcaneadditions.capabilities.familiar;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.capabilities.resource.ICastingResource;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.magic.resources.CastingResourceRegistry;
import com.mna.capabilities.playerdata.magic.resources.Mana;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.sosly.arcaneadditions.ArcaneAdditions;
import org.sosly.arcaneadditions.capabilities.familiar.IFamiliarCapability;
import org.sosly.arcaneadditions.config.ServerConfig;
import org.sosly.arcaneadditions.spells.FamiliarSpell;
import org.sosly.arcaneadditions.utils.FamiliarHelper;

public class FamiliarCapability
implements IFamiliarCapability {
    private boolean bapped = false;
    private Player caster;
    private ICastingResource castingResource = new Mana();
    private Mob familiar;
    private UUID familiarUUID;
    private CompoundTag familiarNBT;
    private long lastInteract;
    private long lastResourceTick;
    private long lastMaintenanceTick;
    private long lastHealingTick;
    private Level loadLevel;
    private BlockPos loadPos;
    private String name = "";
    private boolean orderedToStay = false;
    private LinkedHashSet<FamiliarSpell> spellsKnown = new LinkedHashSet();
    private EntityType<? extends Mob> type;
    private ResourceKey<Level> lastKnownDimension;

    @Override
    public boolean isBapped() {
        return this.bapped;
    }

    @Override
    public void setBapped(boolean value) {
        this.bapped = value;
    }

    @Override
    public Player getCaster() {
        return this.caster;
    }

    @Override
    public void setCaster(Player value) {
        this.caster = value;
    }

    @Override
    public ICastingResource getCastingResource() {
        return this.castingResource;
    }

    @Override
    public void setCastingResourceType(ResourceLocation resourceLocation) {
        if (resourceLocation == null) {
            return;
        }
        if (resourceLocation.m_135815_().isEmpty()) {
            return;
        }
        if (this.getCastingResource().getRegistryName().equals((Object)resourceLocation)) {
            return;
        }
        Class resource = CastingResourceRegistry.Instance.getRegisteredClass(resourceLocation);
        float amount = this.castingResource.getAmount();
        try {
            this.castingResource = (ICastingResource)resource.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.castingResource.setMaxAmountByLevel(this.getMagicLevel());
            this.castingResource.setAmount(amount);
        }
        catch (Exception err) {
            ArcaneAdditions.LOGGER.error("Failed to set casting resource type from identifier {}", (Object)resourceLocation);
            ArcaneAdditions.LOGGER.error("Error setting casting resource type", (Throwable)err);
        }
    }

    @Override
    public Mob getFamiliar() {
        Mob found;
        if (this.familiar != null && !this.familiar.m_213877_() && this.familiar.m_9236_().m_46472_().equals(this.caster.m_9236_().m_46472_())) {
            return this.familiar;
        }
        if (this.familiarUUID == null) {
            return null;
        }
        MinecraftServer server = this.getCaster().m_20194_();
        if (server == null) {
            return null;
        }
        if (this.lastKnownDimension != null && (found = this.searchDimension(server.m_129880_(this.lastKnownDimension))) != null) {
            this.familiar = found;
            return this.familiar;
        }
        for (ServerLevel level : server.m_129785_()) {
            Mob found2;
            if (this.lastKnownDimension != null && level.m_46472_().equals(this.lastKnownDimension) || (found2 = this.searchDimension(level)) == null) continue;
            this.familiar = found2;
            this.lastKnownDimension = level.m_46472_();
            return this.familiar;
        }
        this.familiar = null;
        this.lastKnownDimension = null;
        return null;
    }

    private Mob searchDimension(ServerLevel level) {
        if (level == null) {
            return null;
        }
        Mob entity = (Mob)level.m_8791_(this.familiarUUID);
        if (entity == null || entity.m_213877_()) {
            return null;
        }
        return entity;
    }

    @Override
    public void setFamiliar(Mob value) {
        this.familiar = value;
        this.familiarUUID = value != null ? value.m_20148_() : null;
        this.lastKnownDimension = value != null ? value.m_9236_().m_46472_() : null;
    }

    @Override
    public void setFamiliarUUID(UUID value) {
        this.familiarUUID = value;
        this.familiar = null;
        this.lastKnownDimension = null;
    }

    @Override
    public long getLastInteract() {
        return this.lastInteract;
    }

    @Override
    public void setLastInteract(long value) {
        this.lastInteract = value;
    }

    @Override
    public void loadOnNextTick(Level level, BlockPos pos) {
        this.loadLevel = level;
        this.loadPos = pos;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        this.name = value;
    }

    @Override
    public boolean isOrderedToStay() {
        return this.orderedToStay;
    }

    @Override
    public void setOrderedToStay(boolean value) {
        this.orderedToStay = value;
        if (this.familiar == null) {
            return;
        }
        String[] methodNames = new String[]{"setInSittingPose", "setOrderedToSit", "setSitting", "setResting", "setInSitPose", "setEntityOnShoulder"};
        Class<?> clazz = this.familiar.getClass();
        for (String methodName : methodNames) {
            try {
                Method method = clazz.getMethod(methodName, Boolean.TYPE);
                method.invoke((Object)this.familiar, value);
                break;
            }
            catch (NoSuchMethodException method) {
            }
            catch (Exception e) {
                ArcaneAdditions.LOGGER.debug("Failed to invoke {} on {}", (Object)methodName, (Object)this.familiar.m_6095_().m_20675_());
            }
        }
        if (this.caster != null) {
            this.lastInteract = this.caster.m_9236_().m_46467_();
        }
    }

    @Override
    public CompoundTag getFamiliarNBT() {
        return this.familiarNBT;
    }

    @Override
    public void setFamiliarNBT(CompoundTag nbt) {
        this.familiarNBT = nbt;
    }

    @Override
    public void storeFamiliarData() {
        if (this.familiar == null || this.familiar.m_213877_()) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        this.familiar.m_20240_(nbt);
        nbt.m_128473_("Pos");
        nbt.m_128473_("Motion");
        nbt.m_128473_("Rotation");
        nbt.m_128473_("FallDistance");
        nbt.m_128473_("Fire");
        nbt.m_128473_("Air");
        nbt.m_128473_("OnGround");
        nbt.m_128473_("Dimension");
        nbt.m_128473_("PortalCooldown");
        nbt.m_128473_("UUID");
        this.familiarNBT = nbt;
    }

    @Override
    public void reset() {
        this.bapped = false;
        this.castingResource = new Mana();
        this.castingResource.setAmount(0.0f);
        this.familiar = null;
        this.familiarUUID = null;
        this.familiarNBT = null;
        this.lastKnownDimension = null;
        this.orderedToStay = false;
        this.spellsKnown = new LinkedHashSet();
    }

    @Override
    public void addSpellKnown(FamiliarSpell spell, boolean checkTiers) {
        int maxKnown;
        AtomicInteger i = new AtomicInteger();
        if (checkTiers) {
            if (this.caster == null) {
                return;
            }
            IPlayerProgression progression = (IPlayerProgression)this.caster.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
            maxKnown = progression.getTier() - 2;
        } else {
            maxKnown = 3;
        }
        this.spellsKnown.removeIf(s -> i.getAndIncrement() > maxKnown || s.getName().equals(spell.getName()));
        this.spellsKnown.add(spell);
    }

    @Override
    public Collection<FamiliarSpell> getSpellsKnown() {
        return this.spellsKnown;
    }

    @Override
    public void tick() {
        if (this.loadLevel != null && this.loadPos != null) {
            if (FamiliarHelper.createFamiliar(this.caster, this.type, (Component)Component.m_237113_((String)this.name), this.loadLevel, this.loadPos)) {
                this.loadLevel = null;
                this.loadPos = null;
            }
            return;
        }
        if (this.caster == null || this.familiar == null) {
            return;
        }
        this.lastResourceTick = this.lastResourceTick > 0L ? this.lastResourceTick : this.caster.m_9236_().m_46467_();
        this.lastHealingTick = this.lastHealingTick > 0L ? this.lastHealingTick : this.caster.m_9236_().m_46467_();
        long l = this.lastMaintenanceTick = this.lastMaintenanceTick > 0L ? this.lastMaintenanceTick : this.caster.m_9236_().m_46467_();
        if (this.lastMaintenanceTick < this.caster.m_9236_().m_46467_() - 40L) {
            this.castingResource.setMaxAmountByLevel(this.getMagicLevel());
            this.lastMaintenanceTick = this.caster.m_9236_().m_46467_();
            if (!this.familiar.m_7770_().getString().equals(this.name)) {
                this.name = this.familiar.m_7770_().getString();
            }
            IPlayerMagic magic = (IPlayerMagic)this.caster.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
            MobEffectInstance resistance = new MobEffectInstance(MobEffects.f_19606_, 200, magic.getMagicLevel() / 15, true, false);
            this.familiar.m_147207_(resistance, (Entity)this.familiar);
        }
        if (this.getCastingResource().getAmount() < this.getCastingResource().getMaxAmount() && this.lastResourceTick < this.caster.m_9236_().m_46467_()) {
            int ticks = (int)(this.caster.m_9236_().m_46467_() - this.lastResourceTick);
            float rate = this.castingResource.getRegenerationRate((LivingEntity)this.familiar);
            float regenPercentage = (float)ticks / rate;
            float restored = regenPercentage * this.castingResource.getMaxAmount();
            this.castingResource.restore(restored);
            this.lastResourceTick = this.caster.m_9236_().m_46467_();
        }
        if (this.familiar.m_21223_() < this.familiar.m_21233_() && this.lastHealingTick < this.caster.m_9236_().m_46467_() - (long)ServerConfig.familiarHealingTickInterval) {
            for (int toRestore = (int)(this.caster.m_9236_().m_46467_() - this.lastHealingTick) / ServerConfig.familiarHealingTickInterval; toRestore > 0 && !(this.familiar.m_21223_() >= this.familiar.m_21233_()) && !((double)this.castingResource.getAmount() < ServerConfig.familiarHealingRate); --toRestore) {
                this.familiar.m_5634_(1.0f);
                this.castingResource.consume((LivingEntity)this.familiar, (float)ServerConfig.familiarHealingRate);
            }
            this.lastHealingTick = this.caster.m_9236_().m_46467_();
        } else if (this.lastHealingTick < this.caster.m_9236_().m_46467_() - (long)ServerConfig.familiarHealingTickInterval) {
            this.lastHealingTick = this.caster.m_9236_().m_46467_();
        }
    }

    @Override
    public EntityType<? extends Mob> getType() {
        return this.type;
    }

    @Override
    public void setType(EntityType<? extends Mob> value) {
        this.type = value;
    }

    private int getMagicLevel() {
        IPlayerMagic magic = (IPlayerMagic)this.caster.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        return magic.getMagicLevel() / 5;
    }

    @Override
    public boolean validateFamiliar() {
        if (this.familiar == null && this.familiarUUID == null) {
            return true;
        }
        if (this.familiar != null && this.familiar.m_213877_()) {
            this.familiar = null;
            this.familiarUUID = null;
            this.lastKnownDimension = null;
            return false;
        }
        if (this.familiarUUID != null && this.familiar == null && this.caster.m_20194_() != null) {
            for (ServerLevel level : this.caster.m_20194_().m_129785_()) {
                Mob found = (Mob)level.m_8791_(this.familiarUUID);
                if (found == null || found.m_213877_()) continue;
                return true;
            }
            this.familiarUUID = null;
            this.lastKnownDimension = null;
            return false;
        }
        return true;
    }
}

